/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.data;

import android.graphics.Paint;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.data.AbstractDataSet;
import cn.jingzhuan.lib.chart.data.CandlestickValue;
import java.util.ArrayList;
import java.util.List;

public class CandlestickDataSet
extends AbstractDataSet<CandlestickValue> {
    private List<CandlestickValue> candlestickValues;
    private boolean mAutoWidth = true;
    private float mCandleWidth = -1.0f;
    private int mIncreasingColor = -505013;
    private int mDecreasingColor = -14816421;
    private int mNeutralColor = -1;
    private int mLimitUpColor = 0;
    private Paint.Style mLimitUpPaintStyle = null;
    private float strokeThickness = 4.0f;
    private Paint.Style mIncreasingPaintStyle = Paint.Style.FILL;
    private Paint.Style mDecreasingPaintStyle = Paint.Style.FILL;

    public CandlestickDataSet(List<CandlestickValue> candlestickValues) {
        this(candlestickValues, 25);
    }

    public CandlestickDataSet(List<CandlestickValue> candlestickValues, int axisDependency) {
        this.candlestickValues = candlestickValues;
        this.setAxisDependency(axisDependency);
    }

    @Override
    public void calcMinMax(Viewport viewport) {
        if (this.candlestickValues == null || this.candlestickValues.isEmpty()) {
            return;
        }
        this.mViewportYMax = -3.4028235E38f;
        this.mViewportYMin = Float.MAX_VALUE;
        for (CandlestickValue e : this.getVisiblePoints(viewport)) {
            this.calcViewportMinMax(e);
        }
    }

    private void calcViewportMinMax(CandlestickValue e) {
        if (Float.isNaN(e.getLow())) {
            return;
        }
        if (Float.isNaN(e.getHigh())) {
            return;
        }
        if (Float.isInfinite(e.getLow())) {
            return;
        }
        if (Float.isInfinite(e.getHigh())) {
            return;
        }
        if (e.getLow() < this.mViewportYMin) {
            this.mViewportYMin = e.getLow();
        }
        if (e.getHigh() > this.mViewportYMax) {
            this.mViewportYMax = e.getHigh();
        }
    }

    @Override
    public int getVisibleValueCount(Viewport viewport) {
        return this.getVisiblePoints(viewport).size();
    }

    @Override
    public int getEntryCount() {
        return this.candlestickValues.size();
    }

    @Override
    public void setValues(List<CandlestickValue> values) {
        this.candlestickValues = values;
    }

    @Override
    public List<CandlestickValue> getValues() {
        return this.candlestickValues;
    }

    @Override
    public boolean addEntry(CandlestickValue e) {
        if (e == null) {
            return false;
        }
        if (this.candlestickValues == null) {
            this.candlestickValues = new ArrayList<CandlestickValue>();
        }
        this.calcViewportMinMax(e);
        return this.candlestickValues.add(e);
    }

    @Override
    public boolean removeEntry(CandlestickValue e) {
        if (e == null) {
            return false;
        }
        this.calcViewportMinMax(e);
        return this.candlestickValues.remove(e);
    }

    @Override
    public int getEntryIndex(CandlestickValue e) {
        return this.candlestickValues.indexOf(e);
    }

    @Override
    public CandlestickValue getEntryForIndex(int index) {
        return this.candlestickValues.get(index);
    }

    public void setAutoWidth(boolean mAutoWidth) {
        this.mAutoWidth = mAutoWidth;
    }

    public boolean isAutoWidth() {
        return this.mAutoWidth;
    }

    public int getDecreasingColor() {
        return this.mDecreasingColor;
    }

    public void setDecreasingColor(int decreasingColor) {
        this.mDecreasingColor = decreasingColor;
    }

    public int getIncreasingColor() {
        return this.mIncreasingColor;
    }

    public void setIncreasingColor(int increasingColor) {
        this.mIncreasingColor = increasingColor;
    }

    public float getCandleWidth() {
        return this.mCandleWidth;
    }

    public void setCandleWidth(float mCandleWidth) {
        this.mCandleWidth = mCandleWidth;
    }

    public int getNeutralColor() {
        return this.mNeutralColor;
    }

    public void setNeutralColor(int mNeutralColor) {
        this.mNeutralColor = mNeutralColor;
    }

    public void setLimitUpColor(int mLimitUpColor) {
        this.mLimitUpColor = mLimitUpColor;
    }

    public int getLimitUpColor() {
        return this.mLimitUpColor;
    }

    public float getStrokeThickness() {
        return this.strokeThickness;
    }

    public void setStrokeThickness(float strokeThickness) {
        this.strokeThickness = strokeThickness;
    }

    public Paint.Style getIncreasingPaintStyle() {
        return this.mIncreasingPaintStyle;
    }

    public void setIncreasingPaintStyle(Paint.Style increasingPaintStyle) {
        this.mIncreasingPaintStyle = increasingPaintStyle;
    }

    public Paint.Style getDecreasingPaintStyle() {
        return this.mDecreasingPaintStyle;
    }

    public void setDecreasingPaintStyle(Paint.Style decreasingPaintStyle) {
        this.mDecreasingPaintStyle = decreasingPaintStyle;
    }

    public Paint.Style getLimitUpPaintStyle() {
        return this.mLimitUpPaintStyle;
    }

    public void setLimitUpPaintStyle(Paint.Style limitUpPaintStyle) {
        this.mLimitUpPaintStyle = limitUpPaintStyle;
    }
}

