/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.support.annotation.NonNull;
import cn.jingzhuan.lib.chart.Chart;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.component.Highlight;
import cn.jingzhuan.lib.chart.data.ChartData;
import cn.jingzhuan.lib.chart.data.LineData;
import cn.jingzhuan.lib.chart.data.LineDataSet;
import cn.jingzhuan.lib.chart.data.PointValue;
import cn.jingzhuan.lib.chart.event.OnViewportChangeListener;
import cn.jingzhuan.lib.chart.renderer.AbstractDataRenderer;
import java.util.List;

public class LineRenderer
extends AbstractDataRenderer<LineDataSet> {
    private LineData lineData;
    private Path linePath = new Path();
    private Path shaderPath;

    public LineRenderer(final Chart chart) {
        super(chart);
        chart.setInternalViewportChangeListener(new OnViewportChangeListener(){

            @Override
            public void onViewportChange(Viewport viewport) {
                LineRenderer.this.mViewport = viewport;
                LineRenderer.this.calcDataSetMinMax();
            }
        });
        final Highlight highlight = new Highlight();
        chart.addOnTouchPointChangeListener(new Chart.OnTouchPointChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void touch(float x, float y) {
                LineData lineData = LineRenderer.this.lineData;
                synchronized (lineData) {
                    for (LineDataSet line : LineRenderer.this.getDataSet()) {
                        int index;
                        if (!line.isHighlightedVerticalEnable() || line.getValues().isEmpty() || (index = LineRenderer.this.getEntryIndexByCoordinate(x, y)) <= 0 || index >= line.getValues().size()) continue;
                        PointValue pointValue = line.getEntryForIndex(index);
                        float xPosition = pointValue.getX();
                        float yPosition = pointValue.getY();
                        if (!(xPosition > 0.0f) || !(yPosition > 0.0f)) continue;
                        highlight.setX(xPosition);
                        highlight.setY(yPosition);
                        highlight.setDataIndex(index);
                        chart.highlightValue(highlight);
                    }
                }
            }
        });
    }

    @Override
    public void renderHighlighted(Canvas canvas, @NonNull Highlight[] highlights) {
        this.mRenderPaint.setStyle(Paint.Style.STROKE);
        this.mRenderPaint.setColor(this.getHighlightColor());
        if (this.mHighlightedDashPathEffect != null) {
            this.mRenderPaint.setPathEffect((PathEffect)this.mHighlightedDashPathEffect);
        }
        for (Highlight highlight : highlights) {
            if (highlight == null) continue;
            canvas.drawLine(highlight.getX(), 0.0f, highlight.getX(), (float)this.mContentRect.bottom, this.mRenderPaint);
            for (LineDataSet lineDataSet : this.getDataSet()) {
                if (!lineDataSet.isHighlightedHorizontalEnable()) continue;
                canvas.drawLine(0.0f, highlight.getY(), (float)this.mContentRect.right, highlight.getY(), this.mRenderPaint);
            }
        }
        this.mRenderPaint.setPathEffect(null);
    }

    @Override
    public void removeDataSet(LineDataSet dataSet) {
        this.lineData.remove(dataSet);
        this.calcDataSetMinMax();
    }

    @Override
    public void clearDataSet() {
        this.lineData.clear();
        this.calcDataSetMinMax();
    }

    @Override
    protected List<LineDataSet> getDataSet() {
        return this.lineData.getDataSets();
    }

    @Override
    public ChartData<LineDataSet> getChartData() {
        if (this.lineData == null) {
            this.lineData = new LineData();
        }
        return this.lineData;
    }

    @Override
    protected void renderDataSet(Canvas canvas, ChartData<LineDataSet> chartData) {
        for (LineDataSet dataSet : this.getDataSet()) {
            if (!dataSet.isVisible()) continue;
            this.drawDataSet(canvas, dataSet, chartData.getLeftMax(), chartData.getLeftMin(), chartData.getRightMax(), chartData.getRightMin());
        }
    }

    private void drawDataSet(Canvas canvas, LineDataSet lineDataSet, float lMax, float lMin, float rMax, float rMin) {
        float max;
        float min;
        this.mRenderPaint.setStrokeWidth((float)lineDataSet.getLineThickness());
        this.mRenderPaint.setColor(lineDataSet.getColor());
        int valueCount = lineDataSet.getEntryCount();
        this.linePath.reset();
        boolean isFirst = true;
        switch (lineDataSet.getAxisDependency()) {
            case 24: {
                min = rMin;
                max = rMax;
                break;
            }
            default: {
                min = lMin;
                max = lMax;
            }
        }
        int count = lineDataSet.getVisibleValueCount(this.mViewport);
        float width = 0.0f;
        if (count > 0) {
            width = (float)this.mContentRect.width() / (float)count;
        }
        for (int i = 0; i < valueCount && i < lineDataSet.getValues().size(); ++i) {
            PointValue point = lineDataSet.getEntryForIndex(i);
            if (Float.isNaN(point.getValue())) continue;
            float xPosition = width * 0.5f + this.getDrawX((float)i / (float)valueCount);
            float yPosition = (max - point.getValue()) / (max - min) * (float)this.mContentRect.height();
            point.setCoordinate(xPosition, yPosition);
            if (isFirst) {
                isFirst = false;
                this.linePath.moveTo(xPosition, yPosition);
                continue;
            }
            this.linePath.lineTo(xPosition, yPosition);
        }
        if (lineDataSet.getShader() != null && lineDataSet.getValues().size() > 0) {
            PointValue pointValue;
            this.mRenderPaint.setStyle(Paint.Style.FILL);
            if (this.shaderPath == null) {
                this.shaderPath = new Path(this.linePath);
            } else {
                this.shaderPath.set(this.linePath);
            }
            int lastIndex = lineDataSet.getValues().size() - 1;
            if (lastIndex >= valueCount) {
                lastIndex = valueCount - 1;
            }
            if ((pointValue = lineDataSet.getEntryForIndex(lastIndex)) != null) {
                this.shaderPath.lineTo(lineDataSet.getValues().get(lastIndex).getX(), (float)this.mContentRect.bottom);
                this.shaderPath.lineTo(0.0f, (float)this.mContentRect.bottom);
                this.shaderPath.lineTo(0.0f, lineDataSet.getValues().get(0).getY());
                this.shaderPath.close();
                this.mRenderPaint.setShader(lineDataSet.getShader());
                canvas.drawPath(this.shaderPath, this.mRenderPaint);
                this.mRenderPaint.setShader(null);
                this.mRenderPaint.setStyle(Paint.Style.STROKE);
            }
        }
        canvas.drawPath(this.linePath, this.mRenderPaint);
    }
}

