/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.data;

import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.data.AbstractVisible;
import cn.jingzhuan.lib.chart.data.IDataSet;
import cn.jingzhuan.lib.chart.data.Value;
import java.util.List;

public abstract class AbstractDataSet<T extends Value>
extends AbstractVisible
implements IDataSet {
    protected float mViewportYMin = Float.MAX_VALUE;
    protected float mViewportYMax = -3.4028235E38f;
    private int mAxisDependency = 23;
    private int mColor = -7829368;
    private int maxVisibleEntryCount = 500;
    private int minVisibleEntryCount = 20;
    private int defaultVisibleEntryCount = -1;
    protected float minValueOffsetPercent = 0.0f;
    protected float maxValueOffsetPercent = 0.0f;
    protected float startXOffset = 0.0f;
    protected float endXOffset = 0.0f;
    private boolean isHighlightedVerticalEnable = false;
    private boolean isHighlightedHorizontalEnable = false;
    private boolean isHighlightedTouchY = false;
    private boolean enable = true;
    private int minValueCount = -1;

    public abstract void setValues(List<T> var1);

    public abstract List<T> getValues();

    public abstract boolean addEntry(T var1);

    public abstract boolean removeEntry(T var1);

    public abstract int getEntryIndex(T var1);

    public abstract T getEntryForIndex(int var1);

    @Override
    public int getAxisDependency() {
        return this.mAxisDependency;
    }

    public void setAxisDependency(int mAxisDependency) {
        this.mAxisDependency = mAxisDependency;
    }

    @Override
    public float getViewportYMin() {
        return this.mViewportYMin;
    }

    @Override
    public float getViewportYMax() {
        return this.mViewportYMax;
    }

    public int getColor() {
        return this.mColor;
    }

    public void setColor(int barColor) {
        this.mColor = barColor;
    }

    public void setHighlightedVerticalEnable(boolean highlightedVerticalEnable) {
        this.isHighlightedVerticalEnable = highlightedVerticalEnable;
    }

    public boolean isHighlightedVerticalEnable() {
        return this.isHighlightedVerticalEnable;
    }

    public void setHighlightedHorizontalEnable(boolean highlightedHorizontalEnable) {
        this.isHighlightedHorizontalEnable = highlightedHorizontalEnable;
    }

    public boolean isHighlightedHorizontalEnable() {
        return this.isHighlightedHorizontalEnable;
    }

    public void setHighlightedTouchY(boolean highlightedTouchY) {
        this.isHighlightedTouchY = highlightedTouchY;
    }

    public boolean isHighlightedTouchY() {
        return this.isHighlightedTouchY;
    }

    public List<T> getVisiblePoints(Viewport viewport) {
        int from = (int)(viewport.left * (float)this.getValues().size());
        int to = (int)(viewport.right * (float)this.getValues().size());
        if (Float.compare(viewport.width(), 1.0f) == 0 && this.defaultVisibleEntryCount > 0 && this.defaultVisibleEntryCount < this.getValues().size()) {
            from = to - this.defaultVisibleEntryCount;
            viewport.left = (float)from / (float)this.getValues().size();
        } else {
            if (this.maxVisibleEntryCount > 0 && to - from > this.maxVisibleEntryCount) {
                from = to - this.maxVisibleEntryCount;
                viewport.left = (float)from / (float)this.getValues().size();
            }
            if (this.minVisibleEntryCount > 0 && this.minVisibleEntryCount < this.getValues().size() && to - from < this.minVisibleEntryCount) {
                if (to >= this.minVisibleEntryCount) {
                    from = to - this.minVisibleEntryCount;
                    viewport.left = (float)from / (float)this.getValues().size();
                } else {
                    to = from + this.minVisibleEntryCount;
                    viewport.right = (float)to / (float)this.getValues().size();
                }
            }
        }
        return this.getValues().subList(from, to);
    }

    @Deprecated
    public int getVisibleValueCount(Viewport viewport) {
        return (int)((viewport.right - viewport.left) * (float)this.getEntryCount());
    }

    public float getVisibleRange(Viewport viewport) {
        return (viewport.right - viewport.left) * (float)this.getEntryCount();
    }

    @Override
    public void setMaxVisibleEntryCount(int maxVisibleEntryCount) {
        this.maxVisibleEntryCount = maxVisibleEntryCount;
    }

    @Override
    public void setMinVisibleEntryCount(int minVisibleEntryCount) {
        this.minVisibleEntryCount = minVisibleEntryCount;
    }

    @Override
    public void setDefaultVisibleEntryCount(int defaultVisibleEntryCount) {
        this.defaultVisibleEntryCount = defaultVisibleEntryCount;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
        this.setVisible(enable);
    }

    @Override
    public boolean isEnable() {
        return this.enable;
    }

    @Override
    public int getMinValueCount() {
        return this.minValueCount;
    }

    public int getStartIndexOffset() {
        int startIndex = 0;
        if (this.minValueCount > 0 && this.getValues() != null && this.getValues().size() > 0) {
            startIndex = this.getEntryCount() - this.getValues().size();
        }
        return startIndex;
    }

    @Override
    public void setMinValueCount(int minValueCount) {
        this.minValueCount = minValueCount;
    }
}

