/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.support.annotation.NonNull;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.base.Chart;
import cn.jingzhuan.lib.chart.component.Highlight;
import cn.jingzhuan.lib.chart.data.CandlestickData;
import cn.jingzhuan.lib.chart.data.CandlestickDataSet;
import cn.jingzhuan.lib.chart.data.CandlestickValue;
import cn.jingzhuan.lib.chart.data.ChartData;
import cn.jingzhuan.lib.chart.event.OnViewportChangeListener;
import cn.jingzhuan.lib.chart.renderer.AbstractDataRenderer;
import cn.jingzhuan.lib.chart.renderer.CandlestickDataSetArrowDecorator;
import java.util.List;

public class CandlestickChartRenderer
extends AbstractDataRenderer<CandlestickDataSet> {
    private float[] mUpperShadowBuffers = new float[4];
    private float[] mLowerShadowBuffers = new float[4];
    private float[] mBodyBuffers = new float[4];
    private CandlestickData chartData;

    public CandlestickChartRenderer(final Chart chart) {
        super(chart);
        chart.setInternalViewportChangeListener(new OnViewportChangeListener(){

            @Override
            public void onViewportChange(Viewport viewport) {
                CandlestickChartRenderer.this.mViewport = viewport;
                CandlestickChartRenderer.this.calcDataSetMinMax();
            }
        });
        final Highlight highlight = new Highlight();
        chart.addOnTouchPointChangeListener(new Chart.OnTouchPointChangeListener(){

            @Override
            public void touch(float x, float y) {
                for (CandlestickDataSet dataSet : CandlestickChartRenderer.this.getDataSet()) {
                    int index;
                    if (!dataSet.isHighlightedVerticalEnable()) continue;
                    int valueCount = dataSet.getEntryCount();
                    if (!(x > (float)CandlestickChartRenderer.this.mContentRect.left) || (index = CandlestickChartRenderer.this.getEntryIndexByCoordinate(x, y) - dataSet.getStartIndexOffset()) >= valueCount || index < 0) continue;
                    CandlestickValue candlestickValue = dataSet.getEntryForIndex(index);
                    float xPosition = candlestickValue.getX();
                    float yPosition = candlestickValue.getY();
                    if (!(xPosition > 0.0f) || !(xPosition > 0.0f)) continue;
                    highlight.setX(xPosition);
                    highlight.setY(yPosition);
                    highlight.setDataIndex(index);
                    chart.highlightValue(highlight);
                }
            }
        });
    }

    @Override
    protected void renderDataSet(Canvas canvas, ChartData<CandlestickDataSet> chartData) {
        for (CandlestickDataSet dataSet : chartData.getDataSets()) {
            if (!dataSet.isVisible()) continue;
            this.drawDataSet(canvas, dataSet, chartData.getLeftMax(), chartData.getLeftMin(), chartData.getRightMax(), chartData.getRightMin());
        }
    }

    private void drawDataSet(Canvas canvas, CandlestickDataSet candlestickDataSet, float lMax, float lMin, float rMax, float rMin) {
        float max;
        float min;
        switch (candlestickDataSet.getAxisDependency()) {
            case 24: {
                min = rMin;
                max = rMax;
                break;
            }
            default: {
                min = lMin;
                max = lMax;
            }
        }
        this.mRenderPaint.setStrokeWidth(candlestickDataSet.getStrokeThickness());
        this.mRenderPaint.setColor(candlestickDataSet.getColor());
        int valueCount = candlestickDataSet.getEntryCount();
        List visibleValues = candlestickDataSet.getVisiblePoints(this.mViewport);
        float scale = 1.0f / this.mViewport.width();
        float step = (float)this.mContentRect.width() * scale / (float)valueCount;
        float startX = (float)this.mContentRect.left - this.mViewport.left * (float)this.mContentRect.width() * scale;
        for (int i = 0; i < valueCount && i < candlestickDataSet.getValues().size(); ++i) {
            float candlestickCenterX;
            CandlestickValue candlestick = candlestickDataSet.getEntryForIndex(i);
            if (!visibleValues.contains(candlestick)) continue;
            float candleWidth = candlestickDataSet.getCandleWidth();
            if (candlestickDataSet.isAutoWidth()) {
                candleWidth = (float)this.mContentRect.width() / candlestickDataSet.getVisibleRange(this.mViewport);
            }
            float xPosition = startX + step * (float)(i + candlestickDataSet.getStartIndexOffset());
            float highY = (max - candlestick.getHigh()) / (max - min) * (float)this.mContentRect.height();
            float lowY = (max - candlestick.getLow()) / (max - min) * (float)this.mContentRect.height();
            float openY = (max - candlestick.getOpen()) / (max - min) * (float)this.mContentRect.height();
            float closeY = (max - candlestick.getClose()) / (max - min) * (float)this.mContentRect.height();
            float widthPercent = 0.8f;
            this.mBodyBuffers[0] = xPosition + (1.0f - widthPercent) * 0.5f * candleWidth;
            this.mBodyBuffers[1] = closeY;
            this.mBodyBuffers[2] = this.mBodyBuffers[0] + candleWidth * widthPercent;
            this.mBodyBuffers[3] = openY;
            this.mUpperShadowBuffers[0] = candlestickCenterX = xPosition + candleWidth * 0.5f;
            this.mUpperShadowBuffers[2] = candlestickCenterX;
            this.mLowerShadowBuffers[0] = candlestickCenterX;
            this.mLowerShadowBuffers[2] = candlestickCenterX;
            candlestick.setCoordinate(candlestickCenterX, closeY);
            if (Float.compare(candlestick.getOpen(), candlestick.getClose()) > 0) {
                this.mUpperShadowBuffers[1] = highY;
                this.mUpperShadowBuffers[3] = openY;
                this.mLowerShadowBuffers[1] = lowY;
                this.mLowerShadowBuffers[3] = closeY;
                if (candlestick.getColor() == 0) {
                    this.mRenderPaint.setColor(candlestickDataSet.getDecreasingColor());
                } else {
                    this.mRenderPaint.setColor(candlestick.getColor());
                }
                if (candlestick.getPaintStyle() != null) {
                    this.mRenderPaint.setStyle(candlestick.getPaintStyle());
                } else {
                    this.mRenderPaint.setStyle(candlestickDataSet.getDecreasingPaintStyle());
                }
            } else if (Float.compare(candlestick.getOpen(), candlestick.getClose()) < 0) {
                this.mUpperShadowBuffers[1] = highY;
                this.mUpperShadowBuffers[3] = closeY;
                this.mLowerShadowBuffers[1] = lowY;
                this.mLowerShadowBuffers[3] = openY;
                if (candlestick.getColor() == 0) {
                    this.mRenderPaint.setColor(candlestickDataSet.getIncreasingColor());
                } else {
                    this.mRenderPaint.setColor(candlestick.getColor());
                }
                if (candlestick.getPaintStyle() != null) {
                    this.mRenderPaint.setStyle(candlestick.getPaintStyle());
                } else {
                    this.mRenderPaint.setStyle(candlestickDataSet.getIncreasingPaintStyle());
                }
            } else {
                this.mUpperShadowBuffers[1] = highY;
                this.mUpperShadowBuffers[3] = openY;
                this.mLowerShadowBuffers[1] = lowY;
                this.mLowerShadowBuffers[3] = this.mUpperShadowBuffers[3];
                if (candlestick.getColor() == 0) {
                    this.mRenderPaint.setColor(candlestickDataSet.getNeutralColor());
                } else {
                    this.mRenderPaint.setColor(candlestick.getColor());
                }
            }
            if (i > 0) {
                boolean isLimitUp;
                CandlestickValue previousValue = candlestickDataSet.getEntryForIndex(i - 1);
                boolean bl = isLimitUp = Float.compare((candlestick.getClose() - previousValue.getClose()) / previousValue.getClose(), 0.095f) > 0;
                if (candlestickDataSet.getLimitUpColor() != 0 && isLimitUp) {
                    this.mRenderPaint.setColor(candlestickDataSet.getLimitUpColor());
                }
                if (candlestickDataSet.getLimitUpPaintStyle() != null && isLimitUp) {
                    this.mRenderPaint.setStyle(candlestickDataSet.getLimitUpPaintStyle());
                }
            }
            if (this.mBodyBuffers[1] == this.mBodyBuffers[3]) {
                canvas.drawLine(this.mBodyBuffers[0], this.mBodyBuffers[1], this.mBodyBuffers[2], this.mBodyBuffers[3], this.mRenderPaint);
            } else {
                canvas.drawRect(this.mBodyBuffers[0], this.mBodyBuffers[1], this.mBodyBuffers[2], this.mBodyBuffers[3], this.mRenderPaint);
            }
            canvas.drawLines(this.mUpperShadowBuffers, this.mRenderPaint);
            canvas.drawLines(this.mLowerShadowBuffers, this.mRenderPaint);
            if (!(candlestickDataSet instanceof CandlestickDataSetArrowDecorator)) continue;
            ((CandlestickDataSetArrowDecorator)candlestickDataSet).draw(canvas, candlestick, this.mContentRect, candleWidth, xPosition, highY, lowY);
        }
        if (candlestickDataSet instanceof CandlestickDataSetArrowDecorator) {
            ((CandlestickDataSetArrowDecorator)candlestickDataSet).reset();
        }
    }

    @Override
    public void renderHighlighted(Canvas canvas, @NonNull Highlight[] highlights) {
        this.mRenderPaint.setColor(this.getHighlightColor());
        this.mRenderPaint.setStrokeWidth(2.0f);
        this.mRenderPaint.setStyle(Paint.Style.STROKE);
        if (this.mHighlightedDashPathEffect != null) {
            this.mRenderPaint.setPathEffect((PathEffect)this.mHighlightedDashPathEffect);
        }
        for (Highlight highlight : highlights) {
            for (CandlestickDataSet dataSet : this.getDataSet()) {
                if (dataSet.isHighlightedVerticalEnable()) {
                    canvas.drawLine(highlight.getX(), (float)this.mContentRect.top, highlight.getX(), (float)this.mContentRect.bottom, this.mRenderPaint);
                }
                if (!dataSet.isHighlightedHorizontalEnable()) continue;
                canvas.drawLine((float)this.mContentRect.left, highlight.getY(), (float)this.mContentRect.right, highlight.getY(), this.mRenderPaint);
            }
        }
        this.mRenderPaint.setPathEffect(null);
    }

    @Override
    public void removeDataSet(CandlestickDataSet dataSet) {
        this.getChartData().remove(dataSet);
        this.calcDataSetMinMax();
    }

    @Override
    public void clearDataSet() {
        this.getChartData().clear();
        this.getChartData().calcMaxMin(this.mViewport, this.mContentRect);
    }

    @Override
    public List<CandlestickDataSet> getDataSet() {
        return this.chartData.getDataSets();
    }

    @Override
    public ChartData<CandlestickDataSet> getChartData() {
        if (this.chartData == null) {
            this.chartData = new CandlestickData();
        }
        return this.chartData;
    }
}

