/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.data.CandlestickDataSet;
import cn.jingzhuan.lib.chart.data.CandlestickValue;
import cn.jingzhuan.lib.chart.utils.FloatUtils;

public class CandlestickDataSetArrowDecorator
extends CandlestickDataSet {
    public static final String ARROW_LEFT = "\u2190";
    public static final String ARROW_RIGHT = "\u2192";
    private Paint mPaint;
    private final char[] mLabelBuffer = new char[20];
    private Rect mTextBounds = new Rect();
    private float currentMaxValue = -1.0f;
    private float currentMinValue = -1.0f;

    public CandlestickDataSetArrowDecorator(CandlestickDataSet candlestickDataSet) {
        super(candlestickDataSet.getValues(), candlestickDataSet.getAxisDependency());
        this.mPaint = new Paint(1);
        this.mPaint.setColor(-6181957);
        this.mPaint.setTextSize(30.0f);
    }

    public Paint getPaint() {
        return this.mPaint;
    }

    public void setTextSize(int textSize) {
        this.mPaint.setTextSize((float)textSize);
    }

    @Override
    public void calcMinMax(Viewport viewport) {
        super.calcMinMax(viewport);
        this.reset();
    }

    public void draw(Canvas canvas, CandlestickValue candlestick, Rect contentRect, float candleWidth, float x, float highY, float lowY) {
        String text;
        int length;
        float highValue = candlestick.getHigh();
        float lowValue = candlestick.getLow();
        if (Float.compare(highValue, this.getViewportYMax()) == 0 && this.currentMaxValue < 0.0f) {
            this.currentMaxValue = highValue;
            length = FloatUtils.formatFloatValue(this.mLabelBuffer, highValue, 2);
            if (x < (float)(contentRect.width() >> 1)) {
                this.mPaint.setTextAlign(Paint.Align.LEFT);
                text = ARROW_LEFT + String.valueOf(this.mLabelBuffer, this.mLabelBuffer.length - length, length);
                this.mPaint.getTextBounds(text, 0, text.length(), this.mTextBounds);
                canvas.drawText(text, x + candleWidth * 0.6f, highY + (float)this.mTextBounds.height(), this.getPaint());
            } else {
                this.mPaint.setTextAlign(Paint.Align.RIGHT);
                text = String.valueOf(this.mLabelBuffer, this.mLabelBuffer.length - length, length) + ARROW_RIGHT;
                this.mPaint.getTextBounds(text, 0, text.length(), this.mTextBounds);
                canvas.drawText(text, x + candleWidth * 0.4f, highY + (float)this.mTextBounds.height(), this.getPaint());
            }
        }
        if (Float.compare(lowValue, this.getViewportYMin()) == 0 && this.currentMinValue < 0.0f) {
            this.currentMinValue = lowValue;
            length = FloatUtils.formatFloatValue(this.mLabelBuffer, lowValue, 2);
            if (x < (float)(contentRect.width() >> 1)) {
                this.mPaint.setTextAlign(Paint.Align.LEFT);
                text = ARROW_LEFT + String.valueOf(this.mLabelBuffer, this.mLabelBuffer.length - length, length);
                canvas.drawText(text, x + candleWidth * 0.6f, lowY, this.getPaint());
            } else {
                this.mPaint.setTextAlign(Paint.Align.RIGHT);
                text = String.valueOf(this.mLabelBuffer, this.mLabelBuffer.length - length, length) + ARROW_RIGHT;
                canvas.drawText(text, x + candleWidth * 0.4f, lowY, this.getPaint());
            }
        }
    }

    public void reset() {
        this.currentMinValue = -1.0f;
        this.currentMaxValue = -1.0f;
    }
}

