/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import cn.jingzhuan.lib.chart.data.CandlestickDataSet;
import cn.jingzhuan.lib.chart.data.CandlestickValue;
import cn.jingzhuan.lib.chart.utils.FloatUtils;

public class CandlestickDataSetArrowDecorator
extends CandlestickDataSet {
    public static final String ARROW_LEFT = "\u2190";
    public static final String ARROW_RIGHT = "\u2192";
    private Paint mPaint;
    private final char[] mLabelBuffer = new char[20];
    private Rect mTextBounds = new Rect();

    public CandlestickDataSetArrowDecorator(CandlestickDataSet candlestickDataSet) {
        super(candlestickDataSet.getValues(), candlestickDataSet.getAxisDependency());
        this.mPaint = new Paint(1);
        this.mPaint.setColor(-6181957);
        this.mPaint.setTextSize(30.0f);
    }

    public Paint getPaint() {
        return this.mPaint;
    }

    public void setTextSize(int textSize) {
        this.mPaint.setTextSize((float)textSize);
    }

    public void draw(Canvas canvas, CandlestickValue candlestick, Rect contentRect, float x, float highY, float lowY, float max, float min, float candleWidth) {
        String text;
        int length;
        if (Float.compare(candlestick.getHigh(), max) == 0) {
            length = FloatUtils.formatFloatValue(this.mLabelBuffer, candlestick.getHigh(), 2);
            if (x < (float)(contentRect.width() >> 1)) {
                this.mPaint.setTextAlign(Paint.Align.LEFT);
                text = ARROW_LEFT + String.valueOf(this.mLabelBuffer, this.mLabelBuffer.length - length, length);
                this.mPaint.getTextBounds(text, 0, text.length(), this.mTextBounds);
                canvas.drawText(text, x + candleWidth * 0.6f, highY + (float)this.mTextBounds.height(), this.getPaint());
            } else {
                this.mPaint.setTextAlign(Paint.Align.RIGHT);
                text = String.valueOf(this.mLabelBuffer, this.mLabelBuffer.length - length, length) + ARROW_RIGHT;
                this.mPaint.getTextBounds(text, 0, text.length(), this.mTextBounds);
                canvas.drawText(text, x + candleWidth * 0.4f, highY + (float)this.mTextBounds.height(), this.getPaint());
            }
        }
        if (Float.compare(candlestick.getLow(), min) == 0) {
            length = FloatUtils.formatFloatValue(this.mLabelBuffer, candlestick.getLow(), 2);
            if (x < (float)(contentRect.width() >> 1)) {
                this.mPaint.setTextAlign(Paint.Align.LEFT);
                text = ARROW_LEFT + String.valueOf(this.mLabelBuffer, this.mLabelBuffer.length - length, length);
                canvas.drawText(text, x + candleWidth * 0.6f, lowY, this.getPaint());
            } else {
                this.mPaint.setTextAlign(Paint.Align.RIGHT);
                text = String.valueOf(this.mLabelBuffer, this.mLabelBuffer.length - length, length) + ARROW_RIGHT;
                canvas.drawText(text, x + candleWidth * 0.4f, lowY, this.getPaint());
            }
        }
    }
}

