/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import cn.jingzhuan.lib.chart.Chart;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.component.Highlight;
import cn.jingzhuan.lib.chart.data.AbstractDataSet;
import cn.jingzhuan.lib.chart.data.ChartData;
import cn.jingzhuan.lib.chart.renderer.Renderer;
import java.util.List;

public abstract class AbstractDataRenderer<T extends AbstractDataSet>
implements Renderer {
    protected Viewport mViewport;
    protected Rect mContentRect;
    protected Paint mRenderPaint;
    protected float[] mDashedHighlightIntervals = null;
    protected float mDashedHighlightPhase = -1.0f;
    protected int maxVisibleEntryCount = 500;
    protected int minVisibleEntryCount = 20;
    protected int defaultVisibleEntryCount = -1;
    private int mHighlightColor = -1;

    public AbstractDataRenderer(Chart chart) {
        this.mViewport = chart.getCurrentViewport();
        this.mContentRect = chart.getContentRect();
        this.getChartData().setChart(chart);
        this.mRenderPaint = new Paint(1);
        this.mRenderPaint.setStyle(Paint.Style.STROKE);
    }

    @Override
    public final void renderer(Canvas canvas) {
        this.renderDataSet(canvas);
    }

    protected void renderDataSet(Canvas canvas) {
        this.renderDataSet(canvas, this.getChartData());
    }

    protected abstract void renderDataSet(Canvas var1, ChartData<T> var2);

    public abstract void renderHighlighted(Canvas var1, @NonNull Highlight[] var2);

    protected float getDrawX(float x) {
        return (float)this.mContentRect.left + (float)this.mContentRect.width() * (x - this.mViewport.left) / this.mViewport.width();
    }

    protected float getDrawY(float y) {
        return (float)this.mContentRect.bottom - (float)this.mContentRect.height() * (y - this.mViewport.top) / this.mViewport.height();
    }

    public void addDataSet(T dataSet) {
        if (dataSet == null) {
            return;
        }
        ((AbstractDataSet)dataSet).setMinVisibleEntryCount(this.minVisibleEntryCount);
        ((AbstractDataSet)dataSet).setMaxVisibleEntryCount(this.maxVisibleEntryCount);
        ((AbstractDataSet)dataSet).setDefaultVisibleEntryCount(this.defaultVisibleEntryCount);
        this.getChartData().add(dataSet);
        this.calcDataSetMinMax();
    }

    public abstract void removeDataSet(T var1);

    public abstract void clearDataSet();

    protected abstract List<T> getDataSet();

    public abstract ChartData<T> getChartData();

    protected void calcDataSetMinMax() {
        this.getChartData().calcMaxMin(this.mViewport, this.mContentRect);
    }

    public void setHighlightColor(int highlightColor) {
        this.mHighlightColor = highlightColor;
    }

    public int getHighlightColor() {
        return this.mHighlightColor;
    }

    public void enableDashPathEffect(float[] intervals, float phase) {
        this.mDashedHighlightIntervals = intervals;
        this.mDashedHighlightPhase = phase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxVisibleEntryCount(int maxVisibleEntryCount) {
        this.maxVisibleEntryCount = maxVisibleEntryCount;
        if (maxVisibleEntryCount <= 0) {
            return;
        }
        List<T> list = this.getDataSet();
        synchronized (list) {
            for (AbstractDataSet t : this.getDataSet()) {
                t.setMaxVisibleEntryCount(maxVisibleEntryCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinVisibleEntryCount(int minVisibleEntryCount) {
        this.minVisibleEntryCount = minVisibleEntryCount;
        if (minVisibleEntryCount <= 0) {
            return;
        }
        List<T> list = this.getDataSet();
        synchronized (list) {
            for (AbstractDataSet t : this.getDataSet()) {
                t.setMinVisibleEntryCount(minVisibleEntryCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultVisibleEntryCount(int defaultVisibleEntryCount) {
        this.defaultVisibleEntryCount = defaultVisibleEntryCount;
        if (defaultVisibleEntryCount <= 0) {
            return;
        }
        List<T> list = this.getDataSet();
        synchronized (list) {
            for (AbstractDataSet t : this.getDataSet()) {
                t.setDefaultVisibleEntryCount(defaultVisibleEntryCount);
            }
        }
    }

    public int getMinVisibleEntryCount() {
        return this.minVisibleEntryCount;
    }

    public int getMaxVisibleEntryCount() {
        return this.maxVisibleEntryCount;
    }

    public int getDefaultVisibleEntryCount() {
        return this.defaultVisibleEntryCount;
    }

    public Paint getRenderPaint() {
        return this.mRenderPaint;
    }
}

