/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.renderer;

import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.support.annotation.NonNull;
import cn.jingzhuan.lib.chart.Chart;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.component.Highlight;
import cn.jingzhuan.lib.chart.data.ChartData;
import cn.jingzhuan.lib.chart.data.LineData;
import cn.jingzhuan.lib.chart.data.LineDataSet;
import cn.jingzhuan.lib.chart.data.PointValue;
import cn.jingzhuan.lib.chart.event.OnViewportChangeListener;
import cn.jingzhuan.lib.chart.renderer.AbstractDataRenderer;
import java.util.List;

public class LineRenderer
extends AbstractDataRenderer<LineDataSet> {
    private LineData lineData;

    public LineRenderer(final Chart chart) {
        super(chart);
        chart.setInternalViewportChangeListener(new OnViewportChangeListener(){

            @Override
            public void onViewportChange(Viewport viewport) {
                LineRenderer.this.mViewport = viewport;
                LineRenderer.this.calcDataSetMinMax();
            }
        });
        chart.addOnTouchPointChangeListener(new Chart.OnTouchPointChangeListener(){

            @Override
            public void touch(float x, float y) {
                for (LineDataSet line : LineRenderer.this.getDataSet()) {
                    PointValue pointValue;
                    int count;
                    if (!line.isHighlightedVerticalEnable() || line.getValues().isEmpty()) continue;
                    int index = LineRenderer.this.getEntryIndexByCoordinate(x, y);
                    if (index >= (count = Math.min(line.getForceValueCount(), line.getValues().size()))) {
                        index = count - 1;
                    }
                    if (index < 0) {
                        index = 0;
                    }
                    if ((pointValue = line.getEntryForIndex(index)) == null) continue;
                    chart.highlightValue(new Highlight(pointValue.getX(), pointValue.getY(), index));
                }
            }
        });
    }

    @Override
    public void renderHighlighted(Canvas canvas, @NonNull Highlight[] highlights) {
        this.mRenderPaint.setStyle(Paint.Style.STROKE);
        this.mRenderPaint.setColor(this.getHighlightColor());
        if (this.mDashedHighlightPhase > 0.0f) {
            this.mRenderPaint.setPathEffect((PathEffect)new DashPathEffect(this.mDashedHighlightIntervals, this.mDashedHighlightPhase));
        }
        for (Highlight highlight : highlights) {
            canvas.drawLine(highlight.getX(), 0.0f, highlight.getX(), (float)this.mContentRect.bottom, this.mRenderPaint);
            for (LineDataSet lineDataSet : this.getDataSet()) {
                if (!lineDataSet.isHighlightedHorizontalEnable()) continue;
                float min = lineDataSet.getViewportYMin();
                float max = lineDataSet.getViewportYMax();
                if (highlight.getDataIndex() >= lineDataSet.getValues().size()) continue;
                float value = lineDataSet.getEntryForIndex(highlight.getDataIndex()).getValue();
                float y = (max - value) / (max - min) * (float)this.mContentRect.height();
                canvas.drawLine(0.0f, y, (float)this.mContentRect.right, y, this.mRenderPaint);
            }
        }
        this.mRenderPaint.setPathEffect(null);
    }

    @Override
    public void removeDataSet(LineDataSet dataSet) {
        this.lineData.remove(dataSet);
        this.calcDataSetMinMax();
    }

    @Override
    public void clearDataSet() {
        this.lineData.clear();
        this.calcDataSetMinMax();
    }

    @Override
    protected List<LineDataSet> getDataSet() {
        return this.lineData.getDataSets();
    }

    @Override
    public ChartData<LineDataSet> getChartData() {
        if (this.lineData == null) {
            this.lineData = new LineData();
        }
        return this.lineData;
    }

    @Override
    protected void renderDataSet(Canvas canvas, ChartData<LineDataSet> chartData) {
        for (LineDataSet dataSet : this.getDataSet()) {
            if (!dataSet.isVisible()) continue;
            this.drawDataSet(canvas, dataSet, chartData.getLeftMax(), chartData.getLeftMin(), chartData.getRightMax(), chartData.getRightMin());
        }
    }

    private void drawDataSet(Canvas canvas, LineDataSet lineDataSet, float lMax, float lMin, float rMax, float rMin) {
        float max;
        float min;
        this.mRenderPaint.setStrokeWidth((float)lineDataSet.getLineThickness());
        this.mRenderPaint.setColor(lineDataSet.getColor());
        int valueCount = lineDataSet.getEntryCount();
        Path path = new Path();
        path.reset();
        boolean isFirst = true;
        switch (lineDataSet.getAxisDependency()) {
            case 24: {
                min = rMin;
                max = rMax;
                break;
            }
            default: {
                min = lMin;
                max = lMax;
            }
        }
        int count = lineDataSet.getVisibleValueCount(this.mViewport);
        float width = 0.0f;
        if (count > 0) {
            width = (float)this.mContentRect.width() / (float)count;
        }
        for (int i = 0; i < valueCount && i < lineDataSet.getValues().size(); ++i) {
            PointValue point = lineDataSet.getEntryForIndex(i);
            float xPosition = width * 0.5f + this.getDrawX((float)i / (float)valueCount);
            float yPosition = (max - point.getValue()) / (max - min) * (float)this.mContentRect.height();
            point.setX(xPosition);
            point.setY(yPosition);
            if (isFirst) {
                isFirst = false;
                path.moveTo(xPosition, yPosition);
                continue;
            }
            path.lineTo(xPosition, yPosition);
        }
        if (lineDataSet.getShader() != null && lineDataSet.getValues().size() > 0) {
            this.mRenderPaint.setStyle(Paint.Style.FILL);
            Path shaderPath = new Path(path);
            int lastIndex = lineDataSet.getValues().size() - 1;
            if (lastIndex >= valueCount) {
                lastIndex = valueCount - 1;
            }
            shaderPath.lineTo(lineDataSet.getValues().get(lastIndex).getX(), (float)this.mContentRect.bottom);
            shaderPath.lineTo(0.0f, (float)this.mContentRect.bottom);
            shaderPath.lineTo(0.0f, lineDataSet.getValues().get(0).getY());
            shaderPath.close();
            this.mRenderPaint.setShader(lineDataSet.getShader());
            canvas.drawPath(shaderPath, this.mRenderPaint);
            this.mRenderPaint.setShader(null);
            this.mRenderPaint.setStyle(Paint.Style.STROKE);
        }
        canvas.drawPath(path, this.mRenderPaint);
    }
}

