/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.data;

import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.component.HasValueYOffset;
import cn.jingzhuan.lib.chart.data.AbstractDataSet;
import cn.jingzhuan.lib.chart.data.BarValue;
import cn.jingzhuan.lib.chart.data.ValueFormatter;
import java.util.ArrayList;
import java.util.List;

public class BarDataSet
extends AbstractDataSet<BarValue>
implements HasValueYOffset {
    private List<BarValue> mBarValues;
    private float mBarWidth = 20.0f;
    private boolean mAutoBarWidth = false;
    private int mForceValueCount = -1;
    private float strokeThickness = 2.0f;
    private float mBarWidthPercent = 0.8f;
    private boolean drawValueEnable = false;
    private int valueColor = -16777216;
    private float valueTextSize = 24.0f;
    private ValueFormatter valueFormatter;

    public BarDataSet(List<BarValue> barValues) {
        this(barValues, 25);
    }

    public BarDataSet(List<BarValue> mBarValues, int axisDependency) {
        this.mBarValues = mBarValues;
        this.setAxisDependency(axisDependency);
    }

    @Override
    public int getEntryCount() {
        if (this.mForceValueCount > 0) {
            return this.mForceValueCount;
        }
        if (this.mBarValues != null) {
            return this.mBarValues.size();
        }
        return 0;
    }

    @Override
    public void calcMinMax(Viewport viewport) {
        if (this.mBarValues == null || this.mBarValues.isEmpty()) {
            return;
        }
        this.mViewportYMax = -3.4028235E38f;
        this.mViewportYMin = Float.MAX_VALUE;
        for (BarValue e : this.getVisiblePoints(viewport)) {
            this.calcMinMaxY(e);
        }
        float range = this.mViewportYMax - this.mViewportYMin;
        if ((float)Float.compare(this.getMinValueOffsetPercent(), 0.0f) > 0.0f) {
            this.mViewportYMin -= range * this.getMinValueOffsetPercent();
        }
        if ((float)Float.compare(this.getMaxValueOffsetPercent(), 0.0f) > 0.0f) {
            this.mViewportYMax += range * this.getMaxValueOffsetPercent();
        }
    }

    protected void calcMinMaxY(BarValue e) {
        if (e == null) {
            return;
        }
        for (float v : e.getValues()) {
            this.mViewportYMin = Math.min(this.mViewportYMin, v);
            this.mViewportYMax = Math.max(this.mViewportYMax, v);
        }
    }

    @Override
    public void setValues(List<BarValue> values) {
        this.mBarValues = values;
    }

    @Override
    public List<BarValue> getValues() {
        return this.mBarValues;
    }

    @Override
    public boolean addEntry(BarValue e) {
        if (e == null) {
            return false;
        }
        if (this.mBarValues == null) {
            this.mBarValues = new ArrayList<BarValue>();
        }
        this.calcMinMaxY(e);
        return this.mBarValues.add(e);
    }

    @Override
    public boolean removeEntry(BarValue e) {
        if (e == null) {
            return false;
        }
        this.calcMinMaxY(e);
        return this.mBarValues.remove(e);
    }

    @Override
    public int getEntryIndex(BarValue e) {
        return this.mBarValues.indexOf(e);
    }

    @Override
    public BarValue getEntryForIndex(int index) {
        return this.mBarValues.get(index);
    }

    public float getBarWidth() {
        return this.mBarWidth;
    }

    public void setBarWidth(float mBarWidth) {
        this.mBarWidth = mBarWidth;
    }

    public void setAutoBarWidth(boolean mAutoBarWidth) {
        this.mAutoBarWidth = mAutoBarWidth;
    }

    public boolean isAutoBarWidth() {
        return this.mAutoBarWidth;
    }

    public void setForceValueCount(int forceValueCount) {
        this.mForceValueCount = forceValueCount;
    }

    public int getForceValueCount() {
        return this.mForceValueCount;
    }

    public float getStrokeThickness() {
        return this.strokeThickness;
    }

    public void setStrokeThickness(float strokeThickness) {
        this.strokeThickness = strokeThickness;
    }

    @Override
    public float getMaxValueOffsetPercent() {
        return this.maxValueOffsetPercent;
    }

    @Override
    public float getMinValueOffsetPercent() {
        return this.minValueOffsetPercent;
    }

    @Override
    public void setMinValueOffsetPercent(float minValueOffsetPercent) {
        this.minValueOffsetPercent = minValueOffsetPercent;
    }

    @Override
    public void setMaxValueOffsetPercent(float maxValueOffsetPercent) {
        this.maxValueOffsetPercent = maxValueOffsetPercent;
    }

    public void setDrawValueEnable(boolean drawValueEnable) {
        this.drawValueEnable = drawValueEnable;
    }

    public boolean isDrawValueEnable() {
        return this.drawValueEnable;
    }

    public int getValueColor() {
        return this.valueColor;
    }

    public void setValueColor(int valueColor) {
        this.valueColor = valueColor;
    }

    public float getValueTextSize() {
        return this.valueTextSize;
    }

    public void setValueTextSize(float valueTextSize) {
        this.valueTextSize = valueTextSize;
    }

    public ValueFormatter getValueFormatter() {
        return this.valueFormatter;
    }

    public void setValueFormatter(ValueFormatter valueFormatter) {
        this.valueFormatter = valueFormatter;
    }

    public void setBarWidthPercent(float mBarWidthPercent) {
        this.mBarWidthPercent = mBarWidthPercent;
    }

    public float getBarWidthPercent() {
        return this.mBarWidthPercent;
    }
}

