/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.data;

import android.graphics.Rect;
import cn.jingzhuan.lib.chart.Chart;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.component.AxisY;
import cn.jingzhuan.lib.chart.data.IDataSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ChartData<T extends IDataSet> {
    private List<T> chartData;
    protected float leftMin = Float.MAX_VALUE;
    protected float leftMax = -3.4028235E38f;
    protected float rightMin = Float.MAX_VALUE;
    protected float rightMax = -3.4028235E38f;
    private int entryCount = 0;
    protected AxisY leftAxis;
    protected AxisY rightAxis;

    public ChartData() {
        this.chartData = Collections.synchronizedList(new ArrayList());
    }

    public List<T> getDataSets() {
        if (this.chartData == null) {
            this.chartData = Collections.synchronizedList(new ArrayList());
        }
        return this.chartData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T e) {
        if (e == null) {
            return false;
        }
        ChartData chartData = this;
        synchronized (chartData) {
            return this.getDataSets().add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(T e) {
        ChartData chartData = this;
        synchronized (chartData) {
            return e != null && this.getDataSets().remove(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ChartData chartData = this;
        synchronized (chartData) {
            this.getDataSets().clear();
        }
        this.leftMin = Float.MAX_VALUE;
        this.leftMax = -3.4028235E38f;
        this.rightMin = Float.MAX_VALUE;
        this.rightMax = -3.4028235E38f;
    }

    public void setMinMax() {
        if (this.leftAxis != null && this.leftMin != Float.MAX_VALUE) {
            this.leftAxis.setYMin(this.leftMin);
            this.leftAxis.setYMax(this.leftMax);
        }
        if (this.rightAxis != null && this.rightMin != Float.MAX_VALUE) {
            this.rightAxis.setYMin(this.rightMin);
            this.rightAxis.setYMax(this.rightMax);
        }
    }

    public void calcMaxMin(Viewport viewport, Rect content) {
        this.leftMin = Float.MAX_VALUE;
        this.leftMax = -3.4028235E38f;
        this.rightMin = Float.MAX_VALUE;
        this.rightMax = -3.4028235E38f;
        for (IDataSet t : this.getDataSets()) {
            t.calcMinMax(viewport);
            if (t.getAxisDependency() == 25 || t.getAxisDependency() == 23) {
                this.leftMax = Math.max(this.leftMax, t.getViewportYMax());
                this.leftMin = Math.min(this.leftMin, t.getViewportYMin());
            }
            if (t.getAxisDependency() == 25 || t.getAxisDependency() == 24) {
                this.rightMax = Math.max(this.rightMax, t.getViewportYMax());
                this.rightMin = Math.min(this.rightMin, t.getViewportYMin());
            }
            if (t.getEntryCount() <= this.entryCount) continue;
            this.entryCount = t.getEntryCount();
        }
        this.setMinMax();
    }

    public float getLeftMin() {
        return this.leftMin;
    }

    public float getRightMax() {
        return this.rightMax;
    }

    public float getRightMin() {
        return this.rightMin;
    }

    public float getLeftMax() {
        return this.leftMax;
    }

    public void setLeftMin(float leftMin) {
        this.leftMin = leftMin;
    }

    public void setLeftMax(float leftMax) {
        this.leftMax = leftMax;
    }

    public void setRightMin(float rightMin) {
        this.rightMin = rightMin;
    }

    public void setRightMax(float rightMax) {
        this.rightMax = rightMax;
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public void setChart(Chart chart) {
        this.leftAxis = chart.getAxisLeft();
        this.rightAxis = chart.getAxisRight();
    }
}

