/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.renderer;

import android.graphics.Canvas;
import android.support.annotation.NonNull;
import android.util.Log;
import cn.jingzhuan.lib.chart.Chart;
import cn.jingzhuan.lib.chart.component.Highlight;
import cn.jingzhuan.lib.chart.data.ChartData;
import cn.jingzhuan.lib.chart.data.ScatterData;
import cn.jingzhuan.lib.chart.data.ScatterDataSet;
import cn.jingzhuan.lib.chart.data.ScatterValue;
import cn.jingzhuan.lib.chart.renderer.AbstractDataRenderer;
import java.util.List;

public class ScatterChartRenderer
extends AbstractDataRenderer<ScatterDataSet> {
    private ScatterData scatterData;

    public ScatterChartRenderer(Chart chart) {
        super(chart);
    }

    @Override
    protected void renderDataSet(Canvas canvas, ChartData<ScatterDataSet> chartData) {
        for (ScatterDataSet dataSet : this.getDataSet()) {
            if (!dataSet.isVisible()) continue;
            this.drawDataSet(canvas, dataSet, chartData.getLeftMax(), chartData.getLeftMin(), chartData.getRightMax(), chartData.getRightMin());
        }
    }

    private void drawDataSet(Canvas canvas, ScatterDataSet dataSet, float leftMax, float leftMin, float rightMax, float rightMin) {
        float max;
        float min;
        this.mRenderPaint.setStrokeWidth(2.0f);
        this.mRenderPaint.setColor(dataSet.getColor());
        int valueCount = dataSet.getEntryCount();
        switch (dataSet.getAxisDependency()) {
            case 24: {
                min = rightMin;
                max = rightMax;
                break;
            }
            default: {
                min = leftMin;
                max = leftMax;
            }
        }
        float width = this.mContentRect.width() / dataSet.getVisibleValueCount(this.mViewport);
        Log.d((String)"drawDataSet", (String)("valueCount  = " + valueCount));
        for (int i = 0; i < valueCount && i < dataSet.getValues().size(); ++i) {
            ScatterValue point = dataSet.getEntryForIndex(i);
            float xPosition = width * 0.5f + this.getDrawX((float)i / (float)valueCount);
            float yPosition = (max - point.getValue()) / (max - min) * (float)this.mContentRect.height();
            point.setX(xPosition);
            point.setY(yPosition);
            Log.d((String)"drawDataSet", (String)("drawDataSet x = " + xPosition + ", y = " + yPosition));
            if (dataSet.getShape() == null) continue;
            int x = (int)(xPosition + dataSet.getDrawOffsetX());
            int y = (int)(xPosition + dataSet.getDrawOffsetY());
            dataSet.getShape().setBounds(x, y, x + dataSet.getShape().getIntrinsicWidth(), y + dataSet.getShape().getIntrinsicHeight());
            int saveId = canvas.save();
            dataSet.getShape().draw(canvas);
            canvas.restoreToCount(saveId);
        }
    }

    @Override
    public void renderHighlighted(Canvas canvas, @NonNull Highlight[] highlights) {
    }

    @Override
    public void addDataSet(ScatterDataSet dataSet) {
        this.getChartData().add(dataSet);
    }

    @Override
    public void removeDataSet(ScatterDataSet dataSet) {
        this.getChartData().remove(dataSet);
    }

    @Override
    public void clearDataSet() {
        this.getChartData().clear();
    }

    @Override
    protected List<ScatterDataSet> getDataSet() {
        return this.getChartData().getDataSets();
    }

    @Override
    public ChartData<ScatterDataSet> getChartData() {
        if (this.scatterData == null) {
            this.scatterData = new ScatterData();
        }
        return this.scatterData;
    }
}

