/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.data;

import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.data.AbstractDataSet;
import cn.jingzhuan.lib.chart.data.BarValue;
import java.util.ArrayList;
import java.util.List;

public class BarDataSet
extends AbstractDataSet<BarValue> {
    private List<BarValue> mBarValues;
    private float mBarWidth = 20.0f;
    private boolean mAutoBarWidth = false;
    private int mForceValueCount = -1;
    private float strokeThickness = 2.0f;

    public BarDataSet(List<BarValue> barValues) {
        this(barValues, 25);
    }

    public BarDataSet(List<BarValue> mBarValues, int axisDependency) {
        this.mBarValues = mBarValues;
        this.setAxisDependency(axisDependency);
    }

    @Override
    public int getEntryCount() {
        if (this.mForceValueCount > 0) {
            return this.mForceValueCount;
        }
        if (this.mBarValues != null) {
            return this.mBarValues.size();
        }
        return 0;
    }

    @Override
    public void calcMinMax(Viewport viewport) {
        if (this.mBarValues == null || this.mBarValues.isEmpty()) {
            return;
        }
        this.mViewportYMax = -3.4028235E38f;
        this.mViewportYMin = Float.MAX_VALUE;
        for (BarValue e : this.getVisiblePoints(viewport)) {
            this.calcMinMaxY(e);
        }
    }

    public void calcMinMaxY(BarValue e) {
        if (e == null) {
            return;
        }
        for (float v : e.getValues()) {
            this.mViewportYMin = Math.min(this.mViewportYMin, v);
            this.mViewportYMax = Math.max(this.mViewportYMax, v);
        }
    }

    @Override
    public void setValues(List<BarValue> values) {
        this.mBarValues = values;
    }

    @Override
    public List<BarValue> getValues() {
        return this.mBarValues;
    }

    @Override
    public boolean addEntry(BarValue e) {
        if (e == null) {
            return false;
        }
        if (this.mBarValues == null) {
            this.mBarValues = new ArrayList<BarValue>();
        }
        this.calcMinMaxY(e);
        return this.mBarValues.add(e);
    }

    @Override
    public boolean removeEntry(BarValue e) {
        if (e == null) {
            return false;
        }
        this.calcMinMaxY(e);
        return this.mBarValues.remove(e);
    }

    @Override
    public int getEntryIndex(BarValue e) {
        return this.mBarValues.indexOf(e);
    }

    @Override
    public BarValue getEntryForIndex(int index) {
        return this.mBarValues.get(index);
    }

    public float getBarWidth() {
        return this.mBarWidth;
    }

    public void setBarWidth(float mBarWidth) {
        this.mBarWidth = mBarWidth;
    }

    public void setAutoBarWidth(boolean mAutoBarWidth) {
        this.mAutoBarWidth = mAutoBarWidth;
    }

    public boolean isAutoBarWidth() {
        return this.mAutoBarWidth;
    }

    public void setForceValueCount(int forceValueCount) {
        this.mForceValueCount = forceValueCount;
    }

    public int getForceValueCount() {
        return this.mForceValueCount;
    }

    public float getStrokeThickness() {
        return this.strokeThickness;
    }

    public void setStrokeThickness(float strokeThickness) {
        this.strokeThickness = strokeThickness;
    }
}

