/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.renderer;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import cn.jingzhuan.lib.chart.Chart;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.component.Highlight;
import cn.jingzhuan.lib.chart.data.AbstractDataSet;
import cn.jingzhuan.lib.chart.data.ChartData;
import cn.jingzhuan.lib.chart.renderer.Renderer;
import java.lang.ref.WeakReference;
import java.util.List;

public abstract class AbstractDataRenderer<T extends AbstractDataSet>
implements Renderer {
    protected Viewport mViewport;
    protected Rect mContentRect;
    protected Paint mRenderPaint;
    protected float[] mDashedHighlightIntervals = null;
    protected float mDashedHighlightPhase = -1.0f;
    private int maxVisibleEntryCount = 500;
    private int minVisibleEntryCount = 20;
    protected WeakReference<Bitmap> mDrawBitmap;
    protected Canvas mBitmapCanvas;
    protected Bitmap.Config mBitmapConfig = Bitmap.Config.ARGB_8888;
    private int mHighlightColor = -1;

    public AbstractDataRenderer(Chart chart) {
        this.mViewport = chart.getCurrentViewport();
        this.mContentRect = chart.getContentRect();
        this.getChartData().setChart(chart);
        this.mRenderPaint = new Paint(1);
        this.mRenderPaint.setStyle(Paint.Style.STROKE);
    }

    @Override
    public final void renderer(Canvas canvas) {
        int width = this.mContentRect.width() + this.mContentRect.left;
        int height = this.mContentRect.height();
        if (this.mDrawBitmap == null || ((Bitmap)this.mDrawBitmap.get()).getWidth() != width || ((Bitmap)this.mDrawBitmap.get()).getHeight() != height) {
            if (width > 0 && height > 0) {
                this.mDrawBitmap = new WeakReference<Bitmap>(Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)this.mBitmapConfig));
                this.mBitmapCanvas = new Canvas((Bitmap)this.mDrawBitmap.get());
            } else {
                return;
            }
        }
        ((Bitmap)this.mDrawBitmap.get()).eraseColor(0);
        this.renderDataSet(this.mBitmapCanvas);
        canvas.drawBitmap((Bitmap)this.mDrawBitmap.get(), 0.0f, 0.0f, this.mRenderPaint);
    }

    protected void renderDataSet(Canvas canvas) {
        this.renderDataSet(canvas, this.getChartData());
    }

    protected abstract void renderDataSet(Canvas var1, ChartData<T> var2);

    public abstract void renderHighlighted(Canvas var1, @NonNull Highlight[] var2);

    protected float getDrawX(float x) {
        return (float)this.mContentRect.left + (float)this.mContentRect.width() * (x - this.mViewport.left) / this.mViewport.width();
    }

    protected float getDrawY(float y) {
        return (float)this.mContentRect.bottom - (float)this.mContentRect.height() * (y - this.mViewport.top) / this.mViewport.height();
    }

    public void addDataSet(T dataSet) {
        if (dataSet == null) {
            return;
        }
        ((AbstractDataSet)dataSet).setMinVisibleEntryCount(this.minVisibleEntryCount);
        ((AbstractDataSet)dataSet).setMaxVisibleEntryCount(this.maxVisibleEntryCount);
        this.getChartData().add(dataSet);
        this.calcDataSetMinMax();
    }

    public abstract void removeDataSet(T var1);

    public abstract void clearDataSet();

    protected abstract List<T> getDataSet();

    public abstract ChartData<T> getChartData();

    protected void calcDataSetMinMax() {
        this.getChartData().calcMaxMin(this.mViewport, this.mContentRect);
    }

    public void setHighlightColor(int highlightColor) {
        this.mHighlightColor = highlightColor;
    }

    public int getHighlightColor() {
        return this.mHighlightColor;
    }

    public void enableDashPathEffect(float[] intervals, float phase) {
        this.mDashedHighlightIntervals = intervals;
        this.mDashedHighlightPhase = phase;
    }

    public void setMaxVisibleEntryCount(int maxVisibleEntryCount) {
        this.maxVisibleEntryCount = maxVisibleEntryCount;
        for (AbstractDataSet t : this.getDataSet()) {
            t.setMaxVisibleEntryCount(maxVisibleEntryCount);
        }
    }

    public void setMinVisibleEntryCount(int minVisibleEntryCount) {
        this.minVisibleEntryCount = minVisibleEntryCount;
        for (AbstractDataSet t : this.getDataSet()) {
            t.setMinVisibleEntryCount(minVisibleEntryCount);
        }
    }

    public int getMinVisibleEntryCount() {
        return this.minVisibleEntryCount;
    }

    public int getMaxVisibleEntryCount() {
        return this.maxVisibleEntryCount;
    }

    public Canvas getCacheCanvas() {
        return this.mBitmapCanvas;
    }
}

