/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart;

import android.content.Context;
import android.graphics.Canvas;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import cn.jingzhuan.lib.chart.Chart;
import cn.jingzhuan.lib.chart.component.Highlight;
import cn.jingzhuan.lib.chart.event.HighlightStatusChangeListener;
import cn.jingzhuan.lib.chart.event.OnHighlightListener;
import cn.jingzhuan.lib.chart.renderer.AbstractDataRenderer;
import cn.jingzhuan.lib.chart.renderer.AxisRenderer;
import cn.jingzhuan.lib.chart.renderer.Renderer;
import java.util.ArrayList;
import java.util.List;

public class BaseChart
extends Chart {
    protected AbstractDataRenderer mRenderer;
    private List<AxisRenderer> mAxisRenderers;
    protected Highlight[] mHighlights;
    private HighlightStatusChangeListener mHighlightStatusChangeListener;
    private OnHighlightListener mHighlightListener;
    private int maxVisibleEntryCount = 100;
    private int minVisibleEntryCount = 20;

    public BaseChart(Context context) {
        super(context);
    }

    public BaseChart(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public BaseChart(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @RequiresApi(api=21)
    public BaseChart(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    public void initChart() {
        this.mAxisRenderers = new ArrayList<AxisRenderer>(4);
        this.mAxisRenderers.add(new AxisRenderer(this, this.mAxisTop));
        this.mAxisRenderers.add(new AxisRenderer(this, this.mAxisBottom));
        this.mAxisRenderers.add(new AxisRenderer(this, this.mAxisLeft));
        this.mAxisRenderers.add(new AxisRenderer(this, this.mAxisRight));
    }

    @Override
    protected void drawAxis(Canvas canvas) {
        for (Renderer renderer : this.mAxisRenderers) {
            renderer.renderer(canvas);
        }
    }

    @Override
    protected void drawLabels(Canvas canvas) {
        for (AxisRenderer axisRenderer : this.mAxisRenderers) {
            axisRenderer.drawLabels(canvas);
        }
    }

    @Override
    protected void onTouchPoint(float x, float y) {
        for (Chart.OnTouchPointChangeListener touchPointChangeListener : this.mTouchPointChangeListeners) {
            touchPointChangeListener.touch(x, y);
        }
    }

    @Override
    public void highlightValue(Highlight highlight) {
        if (highlight == null) {
            return;
        }
        Highlight[] highlights = new Highlight[]{highlight};
        if (this.mHighlightStatusChangeListener != null) {
            this.mHighlightStatusChangeListener.onHighlightShow(highlights);
        }
        if (this.mHighlightListener != null) {
            this.mHighlightListener.highlight(highlights);
        }
        this.mHighlights = highlights;
        this.invalidate();
    }

    @Override
    public void cleanHighlight() {
        this.mHighlights = null;
        if (this.mHighlightStatusChangeListener != null) {
            this.mHighlightStatusChangeListener.onHighlightHide();
        }
        this.invalidate();
    }

    public void setRenderer(AbstractDataRenderer renderer) {
        this.mRenderer = renderer;
    }

    @Override
    protected final void render(Canvas canvas) {
        if (this.mRenderer != null) {
            this.mRenderer.renderer(canvas);
        }
        this.drawEdgeEffectsUnclipped(canvas);
        this.renderHighlighted(canvas);
    }

    public void renderHighlighted(Canvas canvas) {
        if (this.mRenderer != null && this.getHighlights() != null) {
            this.mRenderer.renderHighlighted(canvas, this.getHighlights());
        }
    }

    public void setHighlightColor(int color) {
        this.mRenderer.setHighlightColor(color);
    }

    public int getHighlightColor() {
        return this.mRenderer.getHighlightColor();
    }

    public Highlight[] getHighlights() {
        return this.mHighlights;
    }

    public void setHighlights(Highlight[] highlights) {
        this.mHighlights = highlights;
    }

    public void setOnHighlightStatusChangeListener(HighlightStatusChangeListener mHighlightStatusChangeListener) {
        this.mHighlightStatusChangeListener = mHighlightStatusChangeListener;
    }

    public HighlightStatusChangeListener getOnHighlightStatusChangeListener() {
        return this.mHighlightStatusChangeListener;
    }

    public void setOnHighlightListener(OnHighlightListener mHighlightListener) {
        this.mHighlightListener = mHighlightListener;
    }

    public void enableHighlightDashPathEffect(float[] intervals, float phase) {
        this.mRenderer.enableDashPathEffect(intervals, phase);
    }

    public void setMinVisibleEntryCount(int minVisibleEntryCount) {
        this.minVisibleEntryCount = minVisibleEntryCount;
        this.mRenderer.getChartData().setMinVisibleEntryCount(minVisibleEntryCount);
    }

    public void setMaxVisibleEntryCount(int maxVisibleEntryCount) {
        this.maxVisibleEntryCount = maxVisibleEntryCount;
        this.mRenderer.getChartData().setMaxVisibleEntryCount(maxVisibleEntryCount);
    }
}

