/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.widget;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import cn.jingzhuan.lib.chart.BaseChart;
import cn.jingzhuan.lib.chart.data.BarDataSet;
import cn.jingzhuan.lib.chart.data.CandlestickDataSet;
import cn.jingzhuan.lib.chart.data.CombineData;
import cn.jingzhuan.lib.chart.data.LineDataSet;
import cn.jingzhuan.lib.chart.data.ScatterDataSet;
import cn.jingzhuan.lib.chart.renderer.CombineChartRenderer;
import java.util.List;

public class CombineChart
extends BaseChart {
    public CombineChart(Context context) {
        super(context);
    }

    public CombineChart(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public CombineChart(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @RequiresApi(api=21)
    public CombineChart(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    public void initChart() {
        super.initChart();
        this.mRenderer = new CombineChartRenderer(this);
    }

    public void addDataSet(BarDataSet barDataSet) {
        this.getRenderer().addDataSet(barDataSet);
    }

    public void addDataSet(LineDataSet lineDataSet) {
        this.getRenderer().addDataSet(lineDataSet);
    }

    public void addDataSet(ScatterDataSet scatterDataSet) {
        this.getRenderer().addDataSet(scatterDataSet);
    }

    public void addDataSet(CandlestickDataSet candlestickDataSet) {
        this.getRenderer().addDataSet(candlestickDataSet);
        this.triggerViewportChange();
    }

    public void setDataSet(BarDataSet barDataSet) {
        this.cleanAllDataSet();
        this.addDataSet(barDataSet);
    }

    public void setDataSet(LineDataSet lineDataSet) {
        this.cleanAllDataSet();
        this.addDataSet(lineDataSet);
    }

    public void setDataSet(CandlestickDataSet candlestickDataSet) {
        this.cleanAllDataSet();
        this.addDataSet(candlestickDataSet);
    }

    public void setDataSet(ScatterDataSet scatterDataSet) {
        this.cleanAllDataSet();
        this.addDataSet(scatterDataSet);
    }

    public void setLineData(List<LineDataSet> data) {
        this.cleanAllDataSet();
        for (LineDataSet datum : data) {
            this.addDataSet(datum);
        }
    }

    public void setCombineData(CombineData combineData) {
        this.cleanAllDataSet();
        for (LineDataSet lineDataSet : combineData.getLineData()) {
            this.addDataSet(lineDataSet);
        }
        for (BarDataSet barDataSet : combineData.getBarData()) {
            this.addDataSet(barDataSet);
        }
        for (CandlestickDataSet candlestickDataSet : combineData.getCandlestickData()) {
            this.addDataSet(candlestickDataSet);
        }
        for (ScatterDataSet scatterDataSet : combineData.getScatterData()) {
            this.addDataSet(scatterDataSet);
        }
    }

    public List<LineDataSet> getLineDataSet() {
        return this.getRenderer().getChartData().getLineData();
    }

    public List<BarDataSet> getBarDataSet() {
        return this.getRenderer().getChartData().getBarData();
    }

    public List<CandlestickDataSet> getCandlestickDataSet() {
        return this.getRenderer().getChartData().getCandlestickData();
    }

    public CombineChartRenderer getRenderer() {
        return (CombineChartRenderer)this.mRenderer;
    }

    public void cleanLineDataSet() {
        this.getRenderer().getChartData().getLineChartData().clear();
    }

    public void cleanBarDataSet() {
        this.getRenderer().getChartData().getBarChartData().clear();
    }

    public void cleanCandlestickDataSet() {
        this.getRenderer().getChartData().getCandlestickChartData().clear();
    }

    public void cleanScatterDataSet() {
        this.getRenderer().getChartData().getScatterChartData().clear();
    }

    public void cleanAllDataSet() {
        this.getRenderer().clearDataSet();
    }
}

