package cn.jingzhuan.lib.chart.widget;

import android.content.Context;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;

import cn.jingzhuan.lib.chart.data.CandlestickDataSet;
import cn.jingzhuan.lib.chart.data.ScatterDataSet;
import java.util.List;

import cn.jingzhuan.lib.chart.BaseChart;
import cn.jingzhuan.lib.chart.data.BarDataSet;
import cn.jingzhuan.lib.chart.data.CombineData;
import cn.jingzhuan.lib.chart.data.LineDataSet;
import cn.jingzhuan.lib.chart.renderer.CombineChartRenderer;

/**
 * Created by Donglua on 17/8/2.
 */

public class CombineChart extends BaseChart {

    public CombineChart(Context context) {
        super(context);
    }

    public CombineChart(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public CombineChart(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    public CombineChart(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    public void initChart() {
        super.initChart();

        mRenderer = new CombineChartRenderer(this);
    }

    public void addDataSet(BarDataSet barDataSet) {
        getRenderer().addDataSet(barDataSet);
    }

    public void addDataSet(LineDataSet lineDataSet) {
        getRenderer().addDataSet(lineDataSet);
    }

    public void addDataSet(ScatterDataSet scatterDataSet) {
        getRenderer().addDataSet(scatterDataSet);
    }

    public void addDataSet(CandlestickDataSet candlestickDataSet) {
        getRenderer().addDataSet(candlestickDataSet);
        triggerViewportChange();
    }

    public void setDataSet(BarDataSet barDataSet) {
        cleanAllDataSet();

        addDataSet(barDataSet);
    }

    public void setDataSet(LineDataSet lineDataSet) {
        cleanAllDataSet();

        addDataSet(lineDataSet);
    }

    public void setDataSet(CandlestickDataSet candlestickDataSet) {
        cleanAllDataSet();

        addDataSet(candlestickDataSet);
    }
    public void setDataSet(ScatterDataSet scatterDataSet) {
        cleanAllDataSet();

        addDataSet(scatterDataSet);
    }

    public void setLineData(List<LineDataSet> data) {
        cleanAllDataSet();

        for (LineDataSet datum : data) {
            addDataSet(datum);
        }
    }

    public void setCombineData(final CombineData combineData) {
        cleanAllDataSet();

        for (LineDataSet lineDataSet : combineData.getLineData()) {
            addDataSet(lineDataSet);
        }
        for (BarDataSet barDataSet : combineData.getBarData()) {
            addDataSet(barDataSet);
        }
        for (CandlestickDataSet candlestickDataSet : combineData.getCandlestickData()) {
            addDataSet(candlestickDataSet);
        }
        for (ScatterDataSet scatterDataSet : combineData.getScatterData()) {
            addDataSet(scatterDataSet);
        }

    }

    public List<LineDataSet> getLineDataSet() {
        return getRenderer().getChartData().getLineData();
    }

    public List<BarDataSet> getBarDataSet() {
        return getRenderer().getChartData().getBarData();
    }

    public List<CandlestickDataSet> getCandlestickDataSet() {
        return getRenderer().getChartData().getCandlestickData();
    }

    public CombineChartRenderer getRenderer() {
        return (CombineChartRenderer) mRenderer;
    }

    public void cleanLineDataSet() {
        getRenderer().getChartData().getLineChartData().clear();
    }

    public void cleanBarDataSet() {
        getRenderer().getChartData().getBarChartData().clear();
    }

    public void cleanCandlestickDataSet() {
        getRenderer().getChartData().getCandlestickChartData().clear();
    }
    public void cleanScatterDataSet() {
        getRenderer().getChartData().getScatterChartData().clear();
    }

    public void cleanAllDataSet() {
        getRenderer().clearDataSet();
    }

}
