/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.data;

import android.graphics.Shader;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.data.AbstractDataSet;
import cn.jingzhuan.lib.chart.data.PointValue;
import java.util.ArrayList;
import java.util.List;

public class LineDataSet
extends AbstractDataSet<PointValue> {
    private int mLineThickness = 2;
    protected List<PointValue> mPointValues;
    private int mForceValueCount = -1;
    private Shader shader;

    public LineDataSet(List<PointValue> pointValues) {
        this(pointValues, 25);
    }

    public LineDataSet(List<PointValue> pointValues, int depsAxis) {
        this.mPointValues = pointValues;
        if (this.mPointValues == null) {
            this.mPointValues = new ArrayList<PointValue>();
        }
        this.setAxisDependency(depsAxis);
    }

    public int getLineThickness() {
        return this.mLineThickness;
    }

    public void setLineThickness(int mLineThickness) {
        this.mLineThickness = mLineThickness;
    }

    public List<PointValue> getLines() {
        return this.mPointValues;
    }

    @Override
    public int getEntryCount() {
        if (this.mPointValues == null) {
            return 0;
        }
        return this.mForceValueCount > 0 ? this.mForceValueCount : this.mPointValues.size();
    }

    @Override
    public void calcMinMax(Viewport viewport) {
        if (this.mPointValues == null || this.mPointValues.isEmpty()) {
            return;
        }
        this.mYMax = -3.4028235E38f;
        this.mYMin = Float.MAX_VALUE;
        this.mXMax = -3.4028235E38f;
        this.mXMin = Float.MAX_VALUE;
        this.calcViewportY(viewport);
    }

    public void calcViewportY(Viewport viewport) {
        this.mViewportYMax = -3.4028235E38f;
        this.mViewportYMin = Float.MAX_VALUE;
        for (PointValue e : this.getVisiblePoints(viewport)) {
            this.calcViewportMinMax(e);
        }
    }

    @Override
    public void setValues(List<PointValue> values) {
        this.mPointValues = values;
    }

    @Override
    public List<PointValue> getValues() {
        return this.mPointValues;
    }

    public void calcMinMax(PointValue e) {
        if (e == null) {
            return;
        }
        this.calcMinMaxX(e);
        this.calcMinMaxY(e);
    }

    protected void calcViewportMinMax(PointValue e) {
        if (e.getValue() < this.mViewportYMin) {
            this.mViewportYMin = e.getValue();
        }
        if (e.getValue() > this.mViewportYMax) {
            this.mViewportYMax = e.getValue();
        }
    }

    protected void calcMinMaxX(PointValue e) {
    }

    protected void calcMinMaxY(PointValue e) {
        if (e.getValue() < this.mYMin) {
            this.mYMin = e.getValue();
        }
        if (e.getValue() > this.mYMax) {
            this.mYMax = e.getValue();
        }
    }

    @Override
    public boolean addEntry(PointValue e) {
        if (e == null) {
            return false;
        }
        if (this.mPointValues == null) {
            this.mPointValues = new ArrayList<PointValue>();
        }
        this.calcMinMax(e);
        return this.mPointValues.add(e);
    }

    @Override
    public boolean removeEntry(PointValue e) {
        if (e == null) {
            return false;
        }
        if (this.mPointValues == null) {
            return false;
        }
        boolean removed = this.mPointValues.remove(e);
        return removed;
    }

    @Override
    public int getEntryIndex(PointValue e) {
        return this.mPointValues.indexOf(e);
    }

    @Override
    public PointValue getEntryForIndex(int index) {
        return this.mPointValues.get(index);
    }

    public void setForceValueCount(int mForceValueCount) {
        this.mForceValueCount = mForceValueCount;
    }

    public int getForceValueCount() {
        return this.mForceValueCount;
    }

    protected List<PointValue> getVisiblePoints(Viewport viewport) {
        int from = (int)(viewport.left * (float)this.mPointValues.size());
        int to = (int)(viewport.right * (float)this.mPointValues.size());
        return this.mPointValues.subList(from, to);
    }

    public Shader getShader() {
        return this.shader;
    }

    public void setShader(Shader shader) {
        this.shader = shader;
    }
}

