/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.renderer;

import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.support.annotation.NonNull;
import cn.jingzhuan.lib.chart.Chart;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.component.Highlight;
import cn.jingzhuan.lib.chart.data.ChartData;
import cn.jingzhuan.lib.chart.data.LineData;
import cn.jingzhuan.lib.chart.data.LineDataSet;
import cn.jingzhuan.lib.chart.data.PointValue;
import cn.jingzhuan.lib.chart.event.OnViewportChangeListener;
import cn.jingzhuan.lib.chart.renderer.AbstractDataRenderer;
import java.util.List;

public class LineRenderer
extends AbstractDataRenderer<LineDataSet> {
    private LineData lineData;

    public LineRenderer(final Chart chart) {
        super(chart);
        chart.setInternalViewportChangeListener(new OnViewportChangeListener(){

            @Override
            public void onViewportChange(Viewport viewport) {
                LineRenderer.this.calcDataSetMinMax();
            }
        });
        chart.addOnTouchPointChangeListener(new Chart.OnTouchPointChangeListener(){

            @Override
            public void touch(float x, float y) {
                for (LineDataSet line : LineRenderer.this.getDataSet()) {
                    if (!line.isHighlightedEnable()) continue;
                    float xPositionMax = line.getEntryForIndex(line.getValues().size() - 1).getX();
                    int index = 0;
                    if (x > (float)LineRenderer.this.mContentRect.left) {
                        index = (int)((float)line.getEntryCount() * (x - (float)LineRenderer.this.mContentRect.left) * LineRenderer.this.mViewport.width() / (float)LineRenderer.this.mContentRect.width() + LineRenderer.this.mViewport.left);
                    }
                    if (index >= line.getValues().size()) {
                        index = line.getValues().size() - 1;
                    }
                    if (x > xPositionMax) {
                        x = xPositionMax;
                    }
                    chart.highlightValue(new Highlight(x, y, index));
                }
            }
        });
    }

    @Override
    public void renderHighlighted(Canvas canvas, @NonNull Highlight[] highlights) {
        this.mRenderPaint.setStyle(Paint.Style.STROKE);
        this.mRenderPaint.setColor(this.getHighlightColor());
        if (this.mDashedHighlightPhase > 0.0f) {
            this.mRenderPaint.setPathEffect((PathEffect)new DashPathEffect(this.mDashedHighlightIntervals, this.mDashedHighlightPhase));
        }
        for (Highlight highlight : highlights) {
            Canvas c = this.mBitmapCanvas == null ? canvas : this.mBitmapCanvas;
            c.drawLine(highlight.getX(), 0.0f, highlight.getX(), (float)this.mContentRect.bottom, this.mRenderPaint);
            for (LineDataSet lineDataSet : this.getDataSet()) {
                if (!lineDataSet.isHighlightedHorizontalEnable()) continue;
                float min = lineDataSet.getViewportYMin();
                float max = lineDataSet.getViewportYMax();
                float value = lineDataSet.getEntryForIndex(highlight.getDataIndex()).getValue();
                float y = (max - value) / (max - min) * (float)this.mContentRect.height();
                c.drawLine(0.0f, y, (float)this.mContentRect.right, y, this.mRenderPaint);
            }
        }
        this.mRenderPaint.setPathEffect(null);
    }

    @Override
    public void addDataSet(LineDataSet dataSet) {
        this.lineData.add(dataSet);
        this.calcDataSetMinMax();
    }

    @Override
    public void removeDataSet(LineDataSet dataSet) {
        this.lineData.remove(dataSet);
        this.calcDataSetMinMax();
    }

    @Override
    public void clearDataSet() {
        this.lineData.clear();
        this.calcDataSetMinMax();
    }

    @Override
    protected List<LineDataSet> getDataSet() {
        return this.lineData.getDataSets();
    }

    @Override
    public ChartData<LineDataSet> getChartData() {
        if (this.lineData == null) {
            this.lineData = new LineData();
        }
        return this.lineData;
    }

    @Override
    public void calcDataSetMinMax() {
        this.lineData.calcMaxMin(this.mViewport, this.mContentRect);
    }

    @Override
    protected void renderDataSet(Canvas canvas) {
        this.renderDataSet(canvas, this.getChartData());
    }

    @Override
    protected void renderDataSet(Canvas canvas, ChartData<LineDataSet> chartData) {
        for (LineDataSet dataSet : this.getDataSet()) {
            if (!dataSet.isVisible()) continue;
            this.drawDataSet(canvas, dataSet, chartData.getLeftMax(), chartData.getLeftMin(), chartData.getRightMax(), chartData.getRightMin());
        }
    }

    private void drawDataSet(Canvas canvas, LineDataSet lineDataSet, float lMax, float lMin, float rMax, float rMin) {
        float max;
        float min;
        this.mRenderPaint.setStrokeWidth((float)lineDataSet.getLineThickness());
        this.mRenderPaint.setColor(lineDataSet.getColor());
        int valueCount = lineDataSet.getEntryCount();
        Path path = new Path();
        path.reset();
        boolean isFirst = true;
        switch (lineDataSet.getAxisDependency()) {
            case 24: {
                min = rMin;
                max = rMax;
                break;
            }
            default: {
                min = lMin;
                max = lMax;
            }
        }
        for (int i = 0; i < valueCount && i < lineDataSet.getValues().size(); ++i) {
            PointValue point = lineDataSet.getEntryForIndex(i);
            float xV = this.getDrawX((float)i / ((float)valueCount - 1.0f));
            float yV = (max - point.getValue()) / (max - min) * (float)this.mContentRect.height();
            point.setX(xV);
            point.setY(yV);
            if (isFirst) {
                isFirst = false;
                path.moveTo(xV, yV);
                continue;
            }
            path.lineTo(xV, yV);
        }
        if (lineDataSet.getShader() != null) {
            this.mRenderPaint.setShader(lineDataSet.getShader());
        }
        canvas.drawPath(path, this.mRenderPaint);
        this.mRenderPaint.setShader(null);
    }
}

