/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.utils;

import cn.jingzhuan.lib.chart.AxisAutoValues;

public class FloatUtils {
    public static final int[] POW10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000};

    public static float nextUpF(float f) {
        if (Float.isNaN(f) || f == Float.POSITIVE_INFINITY) {
            return f;
        }
        return Float.intBitsToFloat(Float.floatToRawIntBits(f += 0.0f) + (f >= 0.0f ? 1 : -1));
    }

    public static float nextDownF(float f) {
        if (Float.isNaN(f) || f == Float.NEGATIVE_INFINITY) {
            return f;
        }
        if (f == 0.0f) {
            return -1.4E-45f;
        }
        return Float.intBitsToFloat(Float.floatToRawIntBits(f) + (f > 0.0f ? -1 : 1));
    }

    public static double nextUp(double d) {
        if (Double.isNaN(d) || d == Double.POSITIVE_INFINITY) {
            return d;
        }
        return Double.longBitsToDouble(Double.doubleToRawLongBits(d += 0.0) + (long)(d >= 0.0 ? 1 : -1));
    }

    public static double nextDown(double d) {
        if (Double.isNaN(d) || d == Double.NEGATIVE_INFINITY) {
            return d;
        }
        if (d == 0.0) {
            return -1.4E-45f;
        }
        return Double.longBitsToDouble(Double.doubleToRawLongBits(d) + (long)(d > 0.0 ? -1 : 1));
    }

    public static boolean almostEqual(float a, float b, float absoluteDiff, float relativeDiff) {
        float largest;
        float diff = Math.abs(a - b);
        if (diff <= absoluteDiff) {
            return true;
        }
        float f = largest = (a = Math.abs(a)) > (b = Math.abs(b)) ? a : b;
        return diff <= largest * relativeDiff;
    }

    public static float roundToOneSignificantFigure(double num) {
        float d = (float)Math.ceil((float)Math.log10(num < 0.0 ? -num : num));
        int power = 1 - (int)d;
        float magnitude = (float)Math.pow(10.0, power);
        long shifted = Math.round(num * (double)magnitude);
        return (float)shifted / magnitude;
    }

    public static int formatFloat(char[] formattedValue, float value, int endIndex, int digits, char separator) {
        if (digits >= POW10.length) {
            formattedValue[endIndex - 1] = 46;
            return 1;
        }
        boolean negative = false;
        if (value == 0.0f) {
            formattedValue[endIndex - 1] = 48;
            return 1;
        }
        if (value < 0.0f) {
            negative = true;
            value = -value;
        }
        if (digits > POW10.length) {
            digits = POW10.length - 1;
        }
        long lval = Math.round(value *= (float)POW10[digits]);
        int index = endIndex - 1;
        int charsNumber = 0;
        while (lval != 0L || charsNumber < digits + 1) {
            int digit = (int)(lval % 10L);
            lval /= 10L;
            formattedValue[index--] = (char)(digit + 48);
            if (++charsNumber != digits) continue;
            formattedValue[index--] = separator;
            ++charsNumber;
        }
        if (formattedValue[index + 1] == separator) {
            formattedValue[index--] = 48;
            ++charsNumber;
        }
        if (negative) {
            formattedValue[index--] = 45;
            ++charsNumber;
        }
        return charsNumber;
    }

    public static int formatFloatValue(char[] formattedValue, float value, int decimalDigitsNumber) {
        return FloatUtils.formatFloat(formattedValue, value, formattedValue.length, decimalDigitsNumber, '.');
    }

    public static void computeAutoGeneratedAxisValues(float start, float stop, int steps, AxisAutoValues outValues) {
        double intervalValue;
        double intervalMagnitude;
        double range = stop - start;
        if (steps == 0 || range <= 0.0) {
            outValues.values = new float[0];
            outValues.number = 0;
            return;
        }
        double rawInterval = range / (double)steps;
        double interval = FloatUtils.roundToOneSignificantFigure(rawInterval);
        int intervalSigDigit = (int)(interval / (intervalMagnitude = Math.pow(10.0, (int)Math.log10(interval))));
        if (intervalSigDigit > 5) {
            interval = Math.floor(10.0 * intervalMagnitude);
        }
        double first = Math.ceil((double)start / interval) * interval;
        double last = FloatUtils.nextUp(Math.floor((double)stop / interval) * interval);
        int valuesNum = 0;
        for (intervalValue = first; intervalValue <= last; intervalValue += interval) {
            ++valuesNum;
        }
        outValues.number = valuesNum;
        if (outValues.values.length < valuesNum) {
            outValues.values = new float[valuesNum];
        }
        intervalValue = first;
        for (int valueIndex = 0; valueIndex < valuesNum; ++valueIndex) {
            outValues.values[valueIndex] = (float)intervalValue;
            intervalValue += interval;
        }
        outValues.decimals = interval < 1.0 ? (int)Math.ceil(-Math.log10(interval)) : 0;
    }
}

