/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.NonNull;
import cn.jingzhuan.lib.chart.Chart;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.component.Highlight;
import cn.jingzhuan.lib.chart.data.BarData;
import cn.jingzhuan.lib.chart.data.BarDataSet;
import cn.jingzhuan.lib.chart.data.BarValue;
import cn.jingzhuan.lib.chart.data.ChartData;
import cn.jingzhuan.lib.chart.renderer.AbstractDataRenderer;
import java.util.List;

public class BarChartRenderer
extends AbstractDataRenderer<BarDataSet> {
    private BarData mBarDataSets;

    public BarChartRenderer(final Chart chart) {
        super(chart);
        chart.addOnTouchPointChangeListener(new Chart.OnTouchPointChangeListener(){

            @Override
            public void touch(float x, float y) {
                for (BarDataSet dataSet : BarChartRenderer.this.getDataSet()) {
                    if (!dataSet.isHighlightedEnable()) continue;
                    int index = 0;
                    if (x > (float)BarChartRenderer.this.mContentRect.left) {
                        index = (int)((float)dataSet.getEntryCount() * (x - (float)BarChartRenderer.this.mContentRect.left) * BarChartRenderer.this.mViewport.width() / (float)BarChartRenderer.this.mContentRect.width() + BarChartRenderer.this.mViewport.left);
                    }
                    if (index >= dataSet.getValues().size()) {
                        index = dataSet.getValues().size() - 1;
                    }
                    BarValue barValue = dataSet.getEntryForIndex(index);
                    chart.highlightValue(new Highlight(barValue.getX(), barValue.getY(), index));
                }
            }
        });
    }

    public void calcMaxMin(Viewport viewport) {
    }

    @Override
    protected void renderDataSet(Canvas canvas) {
        this.renderDataSet(canvas, this.getChartData());
    }

    @Override
    protected void renderDataSet(Canvas canvas, ChartData<BarDataSet> chartData) {
        for (BarDataSet dataSet : this.getDataSet()) {
            if (!dataSet.isVisible()) continue;
            this.drawBarDataSet(canvas, dataSet);
        }
    }

    private void drawBarDataSet(Canvas canvas, BarDataSet barDataSet) {
        this.mRenderPaint.setStrokeWidth(barDataSet.getBarWidth());
        this.mRenderPaint.setStyle(Paint.Style.FILL);
        int valueCount = barDataSet.getEntryCount();
        float min = barDataSet.getViewportYMin();
        float max = barDataSet.getViewportYMax();
        float width = barDataSet.getBarWidth();
        if (barDataSet.isAutoBarWidth()) {
            width = this.mContentRect.width() / valueCount;
        }
        for (int i = 0; i < valueCount && i < barDataSet.getValues().size(); ++i) {
            BarValue barValue = barDataSet.getEntryForIndex(i);
            if (barValue.getColor() != 0) {
                this.mRenderPaint.setColor(barValue.getColor());
            } else {
                this.mRenderPaint.setColor(barDataSet.getColor());
            }
            float x = this.getDrawX((float)i / ((float)valueCount - 0.0f));
            float bottom = this.calcHeight(0.0f, max, min);
            if (barValue.getValueCount() <= 0) continue;
            float top = this.calcHeight(barValue.getValues()[0], max, min);
            if (barValue.getValueCount() >= 2) {
                bottom = this.calcHeight(barValue.getValues()[1], max, min);
            }
            barValue.setX(x + width * 0.5f);
            barValue.setY(top);
            canvas.drawRect(x, top, x + width, bottom, this.mRenderPaint);
        }
    }

    private float calcHeight(float value, float max, float min) {
        return (max - value) / (max - min) * (float)this.mContentRect.height();
    }

    @Override
    public void renderHighlighted(Canvas canvas, @NonNull Highlight[] highlights) {
        this.mRenderPaint.setColor(this.getHighlightColor());
        this.mRenderPaint.setStrokeWidth(2.0f);
        for (Highlight highlight : highlights) {
            Canvas c = this.mBitmapCanvas == null ? canvas : this.mBitmapCanvas;
            c.drawLine(highlight.getX(), 0.0f, highlight.getX(), (float)this.mContentRect.bottom, this.mRenderPaint);
        }
    }

    @Override
    public void addDataSet(BarDataSet dataSet) {
        if (dataSet == null) {
            return;
        }
        this.mBarDataSets.add(dataSet);
        this.mBarDataSets.setMinMax();
    }

    @Override
    public void removeDataSet(BarDataSet dataSet) {
        if (dataSet == null) {
            return;
        }
        this.mBarDataSets.remove(dataSet);
        this.mBarDataSets.setMinMax();
    }

    @Override
    public void clearDataSet() {
        this.mBarDataSets.clear();
        this.mBarDataSets.setMinMax();
    }

    @Override
    protected List<BarDataSet> getDataSet() {
        return this.mBarDataSets.getDataSets();
    }

    public BarData getChartData() {
        if (this.mBarDataSets == null) {
            this.mBarDataSets = new BarData();
        }
        return this.mBarDataSets;
    }

    @Override
    public void calcDataSetMinMax() {
        for (BarDataSet barDataSet : this.getDataSet()) {
            barDataSet.calcMinMax(this.mViewport);
        }
    }
}

