/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.renderer;

import android.graphics.Canvas;
import android.support.annotation.NonNull;
import cn.jingzhuan.lib.chart.Chart;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.component.Highlight;
import cn.jingzhuan.lib.chart.data.AbstractDataSet;
import cn.jingzhuan.lib.chart.data.BarDataSet;
import cn.jingzhuan.lib.chart.data.CandlestickDataSet;
import cn.jingzhuan.lib.chart.data.ChartData;
import cn.jingzhuan.lib.chart.data.CombineData;
import cn.jingzhuan.lib.chart.data.LineDataSet;
import cn.jingzhuan.lib.chart.event.OnViewportChangeListener;
import cn.jingzhuan.lib.chart.renderer.AbstractDataRenderer;
import cn.jingzhuan.lib.chart.renderer.BarChartRenderer;
import cn.jingzhuan.lib.chart.renderer.CandlestickChartRenderer;
import cn.jingzhuan.lib.chart.renderer.LineRenderer;
import java.util.List;

public class CombineChartRenderer
extends AbstractDataRenderer {
    private BarChartRenderer barChartRenderer;
    private LineRenderer lineRenderer;
    private CandlestickChartRenderer candlestickChartRenderer;
    private CombineData combineData;

    public CombineChartRenderer(Chart chart) {
        super(chart);
        this.lineRenderer = new LineRenderer(chart);
        this.barChartRenderer = new BarChartRenderer(chart);
        this.candlestickChartRenderer = new CandlestickChartRenderer(chart);
        chart.setInternalViewportChangeListener(new OnViewportChangeListener(){

            @Override
            public void onViewportChange(Viewport viewport) {
                CombineChartRenderer.this.combineData.calcDataSetMinMax(viewport, CombineChartRenderer.this.mContentRect);
            }
        });
    }

    @Override
    protected void renderDataSet(Canvas canvas) {
        this.barChartRenderer.renderDataSet(canvas, this.getChartData().getBarChartData());
        this.lineRenderer.renderDataSet(canvas, this.getChartData().getLineChartData());
        this.candlestickChartRenderer.renderDataSet(canvas, this.getChartData().getCandlestickChartData());
    }

    protected void renderDataSet(Canvas canvas, ChartData chartData) {
    }

    @Override
    public void setHighlightColor(int highlightColor) {
        super.setHighlightColor(highlightColor);
        this.lineRenderer.setHighlightColor(highlightColor);
        this.barChartRenderer.setHighlightColor(highlightColor);
        this.candlestickChartRenderer.setHighlightColor(highlightColor);
    }

    @Override
    public void renderHighlighted(Canvas canvas, @NonNull Highlight[] highlights) {
        if (this.lineRenderer.getDataSet() != null && !this.lineRenderer.getDataSet().isEmpty()) {
            this.lineRenderer.renderHighlighted(canvas, highlights);
        }
        if (this.barChartRenderer.getDataSet() != null && !this.barChartRenderer.getDataSet().isEmpty()) {
            this.barChartRenderer.renderHighlighted(canvas, highlights);
        }
        if (this.candlestickChartRenderer.getDataSet() != null && !this.candlestickChartRenderer.getDataSet().isEmpty()) {
            this.candlestickChartRenderer.renderHighlighted(canvas, highlights);
        }
    }

    public void addDataSet(AbstractDataSet dataSet) {
        this.combineData.add(dataSet);
        if (dataSet instanceof LineDataSet) {
            this.lineRenderer.addDataSet((LineDataSet)dataSet);
        } else if (dataSet instanceof BarDataSet) {
            this.barChartRenderer.addDataSet((BarDataSet)dataSet);
        } else if (dataSet instanceof CandlestickDataSet) {
            this.candlestickChartRenderer.addDataSet((CandlestickDataSet)dataSet);
        }
        this.combineData.calcDataSetMinMax(this.mViewport, this.mContentRect);
    }

    public void removeDataSet(AbstractDataSet dataSet) {
        this.combineData.remove(dataSet);
        this.combineData.calcDataSetMinMax(this.mViewport, this.mContentRect);
    }

    @Override
    public void clearDataSet() {
        this.combineData.clear();
        this.lineRenderer.clearDataSet();
        this.barChartRenderer.clearDataSet();
        this.candlestickChartRenderer.clearDataSet();
        this.combineData.getBarChartData().clear();
        this.combineData.getLineChartData().clear();
        this.combineData.getCandlestickChartData().clear();
        this.combineData.calcDataSetMinMax(this.mViewport, this.mContentRect);
    }

    public void cleanLineDataSet() {
        this.lineRenderer.clearDataSet();
        this.combineData.getLineChartData().clear();
    }

    public void cleanBarDataSet() {
        this.lineRenderer.clearDataSet();
        this.combineData.getBarChartData().clear();
    }

    public void cleanCandlestickDataSet() {
        this.candlestickChartRenderer.clearDataSet();
        this.combineData.getCandlestickChartData().clear();
    }

    protected List<AbstractDataSet> getDataSet() {
        return this.combineData.getDataSets();
    }

    public CombineData getChartData() {
        if (this.combineData == null) {
            this.combineData = new CombineData();
        }
        return this.combineData;
    }
}

