/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import cn.jingzhuan.lib.chart.Chart;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.component.Highlight;
import cn.jingzhuan.lib.chart.data.CandlestickDataSet;
import cn.jingzhuan.lib.chart.data.CandlestickValue;
import cn.jingzhuan.lib.chart.data.ChartData;
import cn.jingzhuan.lib.chart.event.OnViewportChangeListener;
import cn.jingzhuan.lib.chart.renderer.AbstractDataRenderer;
import java.util.List;

public class CandlestickChartRenderer
extends AbstractDataRenderer<CandlestickDataSet> {
    private float[] mUpperShadowBuffers = new float[4];
    private float[] mLowerShadowBuffers = new float[4];
    private float[] mBodyBuffers = new float[4];
    private ChartData<CandlestickDataSet> chartData = new ChartData();

    public CandlestickChartRenderer(Chart chart) {
        super(chart);
        chart.setOnViewportChangeListener(new OnViewportChangeListener(){

            @Override
            public void onViewportChange(Viewport viewport) {
                for (CandlestickDataSet dataSet : CandlestickChartRenderer.this.getDataSet()) {
                    dataSet.onViewportChange(CandlestickChartRenderer.this.mContentRect);
                }
            }
        });
    }

    @Override
    protected void renderDataSet(Canvas canvas) {
        for (CandlestickDataSet candlestickDataSet : this.getDataSet()) {
            if (!candlestickDataSet.isVisible()) continue;
            this.drawDataSet(canvas, candlestickDataSet);
        }
    }

    private void drawDataSet(Canvas canvas, CandlestickDataSet candlestickDataSet) {
        float min = candlestickDataSet.getViewportYMin();
        float max = candlestickDataSet.getViewportYMax();
        this.mRenderPaint.setStrokeWidth(5.0f);
        this.mRenderPaint.setColor(candlestickDataSet.getColor());
        int valueCount = candlestickDataSet.getEntryCount();
        Path path = new Path();
        path.reset();
        for (int i = 0; i < valueCount; ++i) {
            CandlestickValue candlestick = candlestickDataSet.getEntryForIndex(i);
            this.mRenderPaint.setStyle(Paint.Style.FILL);
            float candleWidth = candlestickDataSet.getCandleWidth();
            if (candleWidth <= 0.0f) {
                candleWidth = this.mContentRect.width() / valueCount;
            }
            float xPosition = (float)this.mContentRect.left + candleWidth * 0.5f + ((float)this.mContentRect.width() - candleWidth) * ((float)i / ((float)valueCount - 1.0f) - this.mViewport.left) / this.mViewport.width();
            float highY = (max - candlestick.getHigh()) / (max - min) * (float)this.mContentRect.height();
            float lowY = (max - candlestick.getLow()) / (max - min) * (float)this.mContentRect.height();
            float openY = (max - candlestick.getOpen()) / (max - min) * (float)this.mContentRect.height();
            float closeY = (max - candlestick.getClose()) / (max - min) * (float)this.mContentRect.height();
            this.mBodyBuffers[0] = xPosition - candleWidth * 0.4f;
            this.mBodyBuffers[1] = closeY;
            this.mBodyBuffers[2] = xPosition + candleWidth * 0.4f;
            this.mBodyBuffers[3] = openY;
            this.mUpperShadowBuffers[0] = xPosition;
            this.mUpperShadowBuffers[2] = xPosition;
            this.mLowerShadowBuffers[0] = xPosition;
            this.mLowerShadowBuffers[2] = xPosition;
            if (Float.compare(candlestick.getOpen(), candlestick.getClose()) > 0) {
                this.mUpperShadowBuffers[1] = highY;
                this.mUpperShadowBuffers[3] = openY;
                this.mLowerShadowBuffers[1] = lowY;
                this.mLowerShadowBuffers[3] = closeY;
                this.mRenderPaint.setColor(candlestickDataSet.getDecreasingColor());
            } else if (Float.compare(candlestick.getOpen(), candlestick.getClose()) < 0) {
                this.mUpperShadowBuffers[1] = highY;
                this.mUpperShadowBuffers[3] = closeY;
                this.mLowerShadowBuffers[1] = lowY;
                this.mLowerShadowBuffers[3] = openY;
                this.mRenderPaint.setColor(candlestickDataSet.getIncreasingColor());
            } else {
                this.mUpperShadowBuffers[1] = highY;
                this.mUpperShadowBuffers[3] = openY;
                this.mLowerShadowBuffers[1] = lowY;
                this.mLowerShadowBuffers[3] = this.mUpperShadowBuffers[3];
                this.mRenderPaint.setColor(candlestickDataSet.getNeutralColor());
            }
            canvas.drawRect(this.mBodyBuffers[0], this.mBodyBuffers[1], this.mBodyBuffers[2], this.mBodyBuffers[3], this.mRenderPaint);
            canvas.drawLines(this.mUpperShadowBuffers, this.mRenderPaint);
            canvas.drawLines(this.mLowerShadowBuffers, this.mRenderPaint);
        }
    }

    @Override
    public void renderHighlighted(Canvas canvas, Highlight[] highlights) {
    }

    @Override
    public void addDataSet(CandlestickDataSet dataSet) {
        this.chartData.add(dataSet);
    }

    @Override
    public List<CandlestickDataSet> getDataSet() {
        return this.chartData.getDataSets();
    }
}

