/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.data;

import android.graphics.Rect;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.data.AbstractDataSet;
import cn.jingzhuan.lib.chart.data.BarData;
import cn.jingzhuan.lib.chart.data.BarDataSet;
import cn.jingzhuan.lib.chart.data.CandlestickData;
import cn.jingzhuan.lib.chart.data.CandlestickDataSet;
import cn.jingzhuan.lib.chart.data.ChartData;
import cn.jingzhuan.lib.chart.data.LineData;
import cn.jingzhuan.lib.chart.data.LineDataSet;
import java.util.List;

public class CombineData
extends ChartData<AbstractDataSet> {
    private BarData barData = new BarData();
    private LineData lineData = new LineData();
    private CandlestickData candlestickData = new CandlestickData();

    public List<BarDataSet> getBarData() {
        return this.barData.getDataSets();
    }

    public List<LineDataSet> getLineData() {
        return this.lineData.getDataSets();
    }

    public List<CandlestickDataSet> getCandlestickData() {
        return this.candlestickData.getDataSets();
    }

    public boolean addDataSet(BarDataSet dataSet) {
        return this.barData.add(dataSet);
    }

    public boolean addDataSet(LineDataSet dataSet) {
        return this.lineData.add(dataSet);
    }

    public boolean addDataSet(CandlestickDataSet dataSet) {
        return this.candlestickData.add(dataSet);
    }

    public void calcDataSetMinMax(Viewport viewport, Rect content) {
        this.leftMin = Float.MAX_VALUE;
        this.leftMax = -3.4028235E38f;
        this.rightMin = Float.MAX_VALUE;
        this.rightMax = -3.4028235E38f;
        this.candlestickData.calcMaxMin(viewport, content);
        this.leftMin = this.candlestickData.leftMin;
        this.leftMax = this.candlestickData.leftMax;
        this.rightMin = this.candlestickData.rightMin;
        this.rightMax = this.candlestickData.rightMax;
        this.lineData.calcMaxMin(viewport, content);
        this.leftMin = Math.min(this.lineData.leftMin, this.leftMin);
        this.leftMax = Math.max(this.lineData.leftMax, this.leftMax);
        this.rightMin = Math.min(this.lineData.rightMin, this.rightMin);
        this.rightMax = Math.max(this.lineData.rightMax, this.rightMax);
        this.barData.calcMaxMin(viewport, content);
        this.leftMin = Math.min(this.barData.leftMin, this.leftMin);
        this.leftMax = Math.max(this.barData.leftMax, this.leftMax);
        this.rightMin = Math.min(this.barData.rightMin, this.rightMin);
        this.rightMax = Math.max(this.barData.rightMax, this.rightMax);
        this.setMinMax();
    }

    @Override
    public boolean add(AbstractDataSet e) {
        if (e instanceof CandlestickDataSet) {
            return this.addDataSet((CandlestickDataSet)e);
        }
        if (e instanceof LineDataSet) {
            return this.addDataSet((LineDataSet)e);
        }
        if (e instanceof BarDataSet) {
            return this.addDataSet((BarDataSet)e);
        }
        return super.add(e);
    }

    @Override
    public void setMinMax() {
        if (this.leftAxis != null) {
            this.leftAxis.setYMin(this.leftMin);
            this.leftAxis.setYMax(this.leftMax);
        }
        if (this.rightAxis != null) {
            this.rightAxis.setYMin(this.rightMin);
            this.rightAxis.setYMax(this.rightMax);
        }
    }
}

