/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.data;

import android.graphics.Rect;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.data.CandlestickDataSet;
import cn.jingzhuan.lib.chart.data.CandlestickValue;
import cn.jingzhuan.lib.chart.data.ChartData;
import java.util.List;

public class CandlestickData
extends ChartData<CandlestickDataSet> {
    @Override
    public void calcMaxMin(Viewport viewport, Rect content) {
        this.leftMax = -3.4028235E38f;
        this.leftMin = Float.MAX_VALUE;
        this.rightMax = -3.4028235E38f;
        this.rightMin = Float.MAX_VALUE;
        if (this.getDataSets().isEmpty()) {
            return;
        }
        for (CandlestickDataSet candlestickDataSet : this.getDataSets()) {
            candlestickDataSet.calcMinMax(viewport);
            if (candlestickDataSet.getAxisDependency() == 25 || candlestickDataSet.getAxisDependency() == 23) {
                this.leftMin = Math.min(this.leftMin, candlestickDataSet.getYMin());
                this.leftMax = Math.max(this.leftMax, candlestickDataSet.getYMax());
            }
            if (candlestickDataSet.getAxisDependency() != 25 && candlestickDataSet.getAxisDependency() != 24) continue;
            this.rightMin = Math.min(this.rightMin, candlestickDataSet.getYMin());
            this.rightMax = Math.max(this.rightMax, candlestickDataSet.getYMax());
        }
    }

    protected List<CandlestickValue> getVisiblePoints(CandlestickDataSet candlestickDataSet, Viewport viewport) {
        int from = (int)(viewport.left * (float)candlestickDataSet.getValues().size());
        int to = (int)(viewport.right * (float)candlestickDataSet.getValues().size());
        return candlestickDataSet.getValues().subList(from, to);
    }
}

