/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.data;

import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.data.LineDataSet;
import cn.jingzhuan.lib.chart.data.PointValue;
import java.util.List;

public class MinuteLine
extends LineDataSet {
    private float mLastClose = -1.0f;

    public MinuteLine(List<PointValue> pointValues) {
        super(pointValues);
    }

    public MinuteLine(List<PointValue> pointValues, int axisDependency) {
        super(pointValues, axisDependency);
    }

    public float getLastClose() {
        return this.mLastClose;
    }

    public void setLastClose(float lastClose) {
        this.mLastClose = lastClose;
    }

    @Override
    public void calcMinMax() {
        super.calcMinMax();
        if (this.mLastClose > 0.0f) {
            float maxDiff = Math.max(Math.abs(this.mYMin - this.mLastClose), Math.abs(this.mYMax - this.mLastClose));
            maxDiff = Math.max(this.mLastClose * 0.01f, maxDiff);
            this.mYMin = this.mLastClose - maxDiff;
            this.mYMax = this.mLastClose + maxDiff;
        }
    }

    @Override
    public void calcViewportY(Viewport viewport) {
        this.mViewportYMax = -3.4028235E38f;
        this.mViewportYMin = Float.MAX_VALUE;
        for (PointValue e : this.getVisiblePoints(viewport)) {
            this.calcViewportMinMax(e);
        }
        if (this.mLastClose > 0.0f) {
            float maxDiff = Math.max(Math.abs(this.mViewportYMin - this.mLastClose), Math.abs(this.mViewportYMax - this.mLastClose));
            maxDiff = Math.max(this.mLastClose * 0.01f, maxDiff);
            this.mViewportYMin = this.mLastClose - maxDiff;
            this.mViewportYMax = this.mLastClose + maxDiff;
        }
        MinuteLine.setAxisViewportY(this.mAxisLeft, this.mViewportYMin, this.mViewportYMax);
        MinuteLine.setAxisViewportY(this.mAxisRight, this.mViewportYMin, this.mViewportYMax);
    }
}

