/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.data;

import android.graphics.Rect;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.data.AbstractDataSet;
import cn.jingzhuan.lib.chart.data.BarData;
import cn.jingzhuan.lib.chart.data.BarDataSet;
import cn.jingzhuan.lib.chart.data.CandlestickData;
import cn.jingzhuan.lib.chart.data.CandlestickDataSet;
import cn.jingzhuan.lib.chart.data.ChartData;
import cn.jingzhuan.lib.chart.data.LineData;
import cn.jingzhuan.lib.chart.data.LineDataSet;
import java.util.List;

public class CombineData
extends ChartData<AbstractDataSet> {
    private BarData barData = new BarData();
    private LineData lineData = new LineData();
    private CandlestickData candlestickData = new CandlestickData();

    public List<BarDataSet> getBarData() {
        return this.barData.getDataSets();
    }

    public List<LineDataSet> getLineData() {
        return this.lineData.getDataSets();
    }

    public List<CandlestickDataSet> getCandlestickData() {
        return this.candlestickData.getDataSets();
    }

    public void addDataSet(BarDataSet dataSet) {
        this.barData.add(dataSet);
    }

    public void addDataSet(LineDataSet dataSet) {
        this.lineData.add(dataSet);
    }

    public void addDataSet(CandlestickDataSet dataSet) {
        this.candlestickData.add(dataSet);
    }

    public void calcDataSetMinMax(Viewport viewport, Rect content) {
        this.leftMin = Float.MAX_VALUE;
        this.leftMax = -3.4028235E38f;
        this.candlestickData.calcCandlestickDataSetMinMax(viewport, content);
        this.leftMin = this.candlestickData.leftMin;
        this.leftMax = this.candlestickData.leftMax;
        this.rightMin = this.candlestickData.rightMin;
        this.rightMax = this.candlestickData.rightMax;
        this.calcLineDataSetMinMax(viewport, content);
        this.leftMin = Math.min(this.lineData.leftMin, this.candlestickData.leftMin);
        this.leftMax = Math.max(this.lineData.leftMax, this.candlestickData.leftMax);
        this.rightMin = Math.min(this.lineData.rightMin, this.candlestickData.rightMin);
        this.rightMax = Math.max(this.lineData.rightMax, this.candlestickData.rightMax);
    }

    public void calcDataSetMinMax(Rect content) {
        this.calcDataSetMinMax(new Viewport(), content);
        this.calcMinMax();
    }

    @Override
    public boolean add(AbstractDataSet e) {
        if (e instanceof CandlestickDataSet) {
            return this.getCandlestickData().add((CandlestickDataSet)e);
        }
        return super.add(e);
    }

    public void calcLineDataSetMinMax(Viewport viewport, Rect content) {
        this.lineData.leftMax = -3.4028235E38f;
        this.lineData.leftMin = Float.MAX_VALUE;
        for (LineDataSet lineDataSet : this.getLineData()) {
            lineDataSet.onViewportChange(viewport);
            if (lineDataSet.getAxisDependency() == 25 || lineDataSet.getAxisDependency() == 23) {
                this.lineData.leftMax = Math.max(this.lineData.leftMax, lineDataSet.getViewportYMax());
                this.lineData.leftMin = Math.min(this.lineData.leftMin, lineDataSet.getViewportYMin());
            }
            if (lineDataSet.getAxisDependency() != 25 && lineDataSet.getAxisDependency() != 24) continue;
            this.lineData.rightMax = Math.max(this.lineData.rightMax, lineDataSet.getViewportYMax());
            this.lineData.rightMin = Math.min(this.lineData.rightMin, lineDataSet.getViewportYMin());
        }
    }

    public void calcBarDataSetMinMax(Viewport viewport, Rect content) {
        for (BarDataSet barDataSet : this.getBarData()) {
        }
    }

    @Override
    public void calcMinMax() {
        if (this.leftAxis != null) {
            this.leftAxis.setYMin(this.leftMin);
            this.leftAxis.setYMax(this.leftMax);
        }
        if (this.rightAxis != null) {
            this.rightAxis.setYMin(this.rightMin);
            this.rightAxis.setYMax(this.rightMax);
        }
    }
}

