/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.data;

import android.graphics.Rect;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.data.CandlestickDataSet;
import cn.jingzhuan.lib.chart.data.CandlestickValue;
import cn.jingzhuan.lib.chart.data.ChartData;
import java.util.List;

public class CandlestickData
extends ChartData<CandlestickDataSet> {
    public void calcCandlestickDataSetMinMax(Viewport viewport, Rect content) {
        this.leftMax = -3.4028235E38f;
        this.leftMin = Float.MAX_VALUE;
        this.rightMax = -3.4028235E38f;
        this.rightMin = Float.MAX_VALUE;
        if (this.getDataSets().isEmpty()) {
            return;
        }
        for (CandlestickDataSet candlestickDataSet : this.getDataSets()) {
            for (CandlestickValue e : this.getVisiblePoints(candlestickDataSet, viewport)) {
                if (candlestickDataSet.getAxisDependency() == 25 || candlestickDataSet.getAxisDependency() == 23) {
                    if (e.getLow() < this.leftMin) {
                        this.leftMin = e.getLow();
                    }
                    if (e.getHigh() > this.leftMax) {
                        this.leftMax = e.getHigh();
                    }
                }
                if (candlestickDataSet.getAxisDependency() != 25 && candlestickDataSet.getAxisDependency() != 24) continue;
                if (e.getLow() < this.rightMin) {
                    this.rightMin = e.getLow();
                }
                if (!(e.getHigh() > this.rightMax)) continue;
                this.rightMax = e.getHigh();
            }
        }
    }

    protected List<CandlestickValue> getVisiblePoints(CandlestickDataSet candlestickDataSet, Viewport viewport) {
        int from = (int)(viewport.left * (float)candlestickDataSet.getValues().size());
        int to = (int)(viewport.right * (float)candlestickDataSet.getValues().size());
        return candlestickDataSet.getValues().subList(from, to);
    }
}

