/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.data;

import android.graphics.Rect;
import android.util.Log;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.data.AbstractDataSet;
import cn.jingzhuan.lib.chart.data.BarData;
import cn.jingzhuan.lib.chart.data.BarDataSet;
import cn.jingzhuan.lib.chart.data.CandlestickData;
import cn.jingzhuan.lib.chart.data.CandlestickDataSet;
import cn.jingzhuan.lib.chart.data.CandlestickValue;
import cn.jingzhuan.lib.chart.data.ChartData;
import cn.jingzhuan.lib.chart.data.LineData;
import cn.jingzhuan.lib.chart.data.LineDataSet;
import java.util.List;

public class CombineData
extends ChartData<AbstractDataSet> {
    private BarData barData = new BarData();
    private LineData lineData = new LineData();
    private CandlestickData candlestickData = new CandlestickData();

    public List<BarDataSet> getBarData() {
        return this.barData.getDataSets();
    }

    public List<LineDataSet> getLineData() {
        return this.lineData.getDataSets();
    }

    public List<CandlestickDataSet> getCandlestickData() {
        return this.candlestickData.getDataSets();
    }

    public void addDataSet(BarDataSet dataSet) {
        this.barData.add(dataSet);
    }

    public void addDataSet(LineDataSet dataSet) {
        this.lineData.add(dataSet);
    }

    public void addDataSet(CandlestickDataSet dataSet) {
        this.candlestickData.add(dataSet);
    }

    public void calcDataSetMinMax(Viewport viewport, Rect content) {
        this.leftMin = Float.MAX_VALUE;
        this.leftMax = -3.4028235E38f;
        this.calcCandlestickDataSetMinMax(viewport, content);
        this.leftMin = this.candlestickData.leftMin;
        this.leftMax = this.candlestickData.leftMax;
        this.calcLineDataSetMinMax(viewport, content);
        this.leftMin = Math.min(this.lineData.leftMin, this.candlestickData.leftMin);
        this.leftMax = Math.max(this.lineData.leftMax, this.candlestickData.leftMax);
    }

    public void calcDataSetMinMax(Rect content) {
        this.calcDataSetMinMax(new Viewport(), content);
        this.calcMinMax();
    }

    public void calcCandlestickDataSetMinMax(Viewport viewport, Rect content) {
        Log.d((String)"calcCandlestick", (String)("getCandlestickData() = " + this.getCandlestickData().size()));
        this.candlestickData.leftMax = -3.4028235E38f;
        this.candlestickData.leftMin = Float.MAX_VALUE;
        if (this.getCandlestickData().isEmpty()) {
            return;
        }
        for (CandlestickDataSet candlestickDataSet : this.getCandlestickData()) {
            for (CandlestickValue e : this.getVisiblePoints(candlestickDataSet, viewport)) {
                this.calcViewportMinMax(e);
            }
        }
        Log.d((String)"calcCandlestick", (String)(this.candlestickData.leftMax + ", " + this.candlestickData.leftMin));
    }

    @Override
    public boolean add(AbstractDataSet e) {
        if (e instanceof CandlestickDataSet) {
            return this.getCandlestickData().add((CandlestickDataSet)e);
        }
        return super.add(e);
    }

    private void calcViewportMinMax(CandlestickValue e) {
        if (e.getLow() < this.candlestickData.leftMin) {
            this.candlestickData.leftMin = e.getLow();
        }
        if (e.getHigh() > this.candlestickData.leftMax) {
            this.candlestickData.leftMax = e.getHigh();
        }
    }

    public void calcLineDataSetMinMax(Viewport viewport, Rect content) {
        this.lineData.leftMax = -3.4028235E38f;
        this.lineData.leftMin = Float.MAX_VALUE;
        for (LineDataSet lineDataSet : this.getLineData()) {
            lineDataSet.onViewportChange(viewport);
            this.lineData.leftMax = Math.max(this.lineData.leftMax, lineDataSet.getViewportYMax());
            this.lineData.leftMin = Math.min(this.lineData.leftMin, lineDataSet.getViewportYMin());
        }
    }

    public void calcBarDataSetMinMax(Viewport viewport, Rect content) {
        for (BarDataSet barDataSet : this.getBarData()) {
        }
    }

    @Override
    public void calcMinMax() {
        if (this.leftAxis != null) {
            this.leftAxis.setYMin(this.leftMin);
            this.leftAxis.setYMax(this.leftMax);
        }
        if (this.rightAxis != null) {
            this.rightAxis.setYMin(this.rightMin);
            this.rightAxis.setYMax(this.rightMax);
        }
    }

    protected List<CandlestickValue> getVisiblePoints(CandlestickDataSet candlestickDataSet, Viewport viewport) {
        int from = (int)(viewport.left * (float)candlestickDataSet.getValues().size());
        int to = (int)(viewport.right * (float)candlestickDataSet.getValues().size());
        return candlestickDataSet.getValues().subList(from, to);
    }
}

