/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.support.annotation.NonNull;
import cn.jingzhuan.lib.chart.Chart;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.component.Highlight;
import cn.jingzhuan.lib.chart.data.ChartData;
import cn.jingzhuan.lib.chart.data.LineData;
import cn.jingzhuan.lib.chart.data.LineDataSet;
import cn.jingzhuan.lib.chart.data.PointValue;
import cn.jingzhuan.lib.chart.event.OnViewportChangeListener;
import cn.jingzhuan.lib.chart.renderer.AbstractDataRenderer;
import java.util.List;

public class LineRenderer
extends AbstractDataRenderer<LineDataSet> {
    private ChartData<LineDataSet> lineData = new LineData();

    public LineRenderer(final Chart chart) {
        super(chart);
        chart.setOnViewportChangeListener(new OnViewportChangeListener(){

            @Override
            public void onViewportChange(Viewport viewport) {
                LineRenderer.this.calcMaxMin(viewport);
            }
        });
        chart.addOnTouchPointChangeListener(new Chart.OnTouchPointChangeListener(){

            @Override
            public void touch(float x, float y) {
                for (LineDataSet line : LineRenderer.this.getDataSet()) {
                    if (!line.isHighlightedEnable()) continue;
                    float xPositionMax = line.getEntryForIndex(line.getValues().size() - 1).getX();
                    int index = 0;
                    if (x > (float)LineRenderer.this.mContentRect.left) {
                        index = (int)((float)line.getEntryCount() * (x - (float)LineRenderer.this.mContentRect.left) * LineRenderer.this.mViewport.width() / (float)LineRenderer.this.mContentRect.width() + LineRenderer.this.mViewport.left);
                    }
                    if (index >= line.getValues().size()) {
                        index = line.getValues().size() - 1;
                    }
                    if (x > xPositionMax) {
                        x = xPositionMax;
                    }
                    chart.highlightValue(new Highlight(x, y, index));
                }
            }
        });
    }

    protected void calcMaxMin(Viewport viewport) {
        for (LineDataSet line : this.getDataSet()) {
            line.onViewportChange(viewport);
            this.setMax(line.getViewportYMax());
            this.setMin(line.getViewportYMin());
        }
    }

    @Override
    public void renderHighlighted(Canvas canvas, @NonNull Highlight[] highlights) {
        this.mRenderPaint.setStyle(Paint.Style.STROKE);
        this.mRenderPaint.setColor(this.getHighlightColor());
        for (Highlight highlight : highlights) {
            Canvas c = this.mBitmapCanvas == null ? canvas : this.mBitmapCanvas;
            c.drawLine(highlight.getX(), 0.0f, highlight.getX(), (float)this.mContentRect.bottom, this.mRenderPaint);
            for (LineDataSet lineDataSet : this.getDataSet()) {
                if (!lineDataSet.isHighlightedHorizontalEnable()) continue;
                float min = lineDataSet.getViewportYMin();
                float max = lineDataSet.getViewportYMax();
                float value = lineDataSet.getEntryForIndex(highlight.getDataIndex()).getValue();
                float y = (max - value) / (max - min) * (float)this.mContentRect.height();
                canvas.drawLine(0.0f, y, (float)this.mContentRect.right, y, this.mRenderPaint);
            }
        }
    }

    @Override
    public void addDataSet(LineDataSet dataSet) {
        this.lineData.add(dataSet);
    }

    @Override
    public List<LineDataSet> getDataSet() {
        return this.lineData.getDataSets();
    }

    @Override
    protected void renderDataSet(Canvas canvas) {
        for (LineDataSet line : this.getDataSet()) {
            if (!line.isVisible()) continue;
            this.drawDataSet(canvas, line);
        }
    }

    private void drawDataSet(Canvas canvas, LineDataSet lineDataSet) {
        float max;
        float min;
        this.mRenderPaint.setStrokeWidth((float)lineDataSet.getLineThickness());
        this.mRenderPaint.setColor(lineDataSet.getColor());
        int valueCount = lineDataSet.getEntryCount();
        Path path = new Path();
        path.reset();
        boolean isFirst = true;
        switch (lineDataSet.getAxisDependency()) {
            case 24: {
                min = lineDataSet.getAxisRight().getYMin();
                max = lineDataSet.getAxisRight().getYMax();
                break;
            }
            default: {
                min = lineDataSet.getAxisLeft().getYMin();
                max = lineDataSet.getAxisLeft().getYMax();
            }
        }
        for (int i = 0; i < valueCount && i < lineDataSet.getValues().size(); ++i) {
            PointValue point = lineDataSet.getEntryForIndex(i);
            float xV = this.getDrawX((float)i / ((float)valueCount - 1.0f));
            float yV = (max - point.getValue()) / (max - min) * (float)this.mContentRect.height();
            point.setX(xV);
            point.setY(yV);
            if (isFirst) {
                isFirst = false;
                path.moveTo(xV, yV);
                continue;
            }
            path.lineTo(xV, yV);
        }
        canvas.drawPath(path, this.mRenderPaint);
    }
}

