/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart2.widget;

import android.content.Context;
import android.graphics.Typeface;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import cn.jingzhuan.lib.chart2.base.BaseChart;
import cn.jingzhuan.lib.chart2.data.AbstractDataSet;
import cn.jingzhuan.lib.chart2.data.BarDataSet;
import cn.jingzhuan.lib.chart2.data.CandlestickDataSet;
import cn.jingzhuan.lib.chart2.data.CombineData;
import cn.jingzhuan.lib.chart2.data.LineDataSet;
import cn.jingzhuan.lib.chart2.data.ScatterDataSet;
import cn.jingzhuan.lib.chart2.renderer.CombineChartRenderer;
import java.util.List;

public class CombineChart
extends BaseChart {
    public CombineChart(Context context) {
        super(context);
    }

    public CombineChart(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public CombineChart(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @RequiresApi(api=21)
    public CombineChart(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    public void initChart() {
        super.initChart();
        this.mRenderer = new CombineChartRenderer(this);
    }

    public void addDataSet(AbstractDataSet abstractDataSet) {
        this.getRenderer().addDataSet(abstractDataSet);
    }

    public void setDataSet(AbstractDataSet dataSet) {
        this.cleanAllDataSet();
        this.addDataSet(dataSet);
    }

    public void setCombineData(CombineData combineData) {
        this.cleanAllDataSet();
        for (LineDataSet lineDataSet : combineData.getLineData()) {
            this.addDataSet(lineDataSet);
        }
        for (BarDataSet barDataSet : combineData.getBarData()) {
            this.addDataSet(barDataSet);
        }
        for (CandlestickDataSet candlestickDataSet : combineData.getCandlestickData()) {
            this.addDataSet(candlestickDataSet);
        }
        for (ScatterDataSet scatterDataSet : combineData.getScatterData()) {
            this.addDataSet(scatterDataSet);
        }
    }

    public <T extends AbstractDataSet> void setData(List<T> data) {
        this.cleanAllDataSet();
        for (AbstractDataSet datum : data) {
            this.addDataSet(datum);
        }
    }

    public List<LineDataSet> getLineDataSet() {
        return this.getRenderer().getChartData().getLineData();
    }

    public List<BarDataSet> getBarDataSet() {
        return this.getRenderer().getChartData().getBarData();
    }

    public List<CandlestickDataSet> getCandlestickDataSet() {
        return this.getRenderer().getChartData().getCandlestickData();
    }

    public List<ScatterDataSet> getScatterDataSet() {
        return this.getRenderer().getChartData().getScatterData();
    }

    public CombineChartRenderer getRenderer() {
        return (CombineChartRenderer)this.mRenderer;
    }

    @Override
    public void setTypeface(Typeface tf) {
        this.mRenderer.setTypeface(tf);
        super.setTypeface(tf);
    }

    public void cleanLineDataSet() {
        this.getRenderer().cleanLineDataSet();
    }

    public void cleanBarDataSet() {
        this.getRenderer().cleanBarDataSet();
    }

    public void cleanCandlestickDataSet() {
        this.getRenderer().cleanCandlestickDataSet();
    }

    public void cleanScatterDataSet() {
        this.getRenderer().cleanScatterDataSet();
    }

    public void cleanAllDataSet() {
        this.getRenderer().clearDataSet();
    }
}

