/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart2;

import android.content.Context;
import android.os.SystemClock;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;

public class Zoomer {
    private Interpolator mInterpolator = new DecelerateInterpolator();
    private int mAnimationDurationMillis;
    private boolean mFinished = true;
    private float mCurrentZoom;
    private long mStartRTC;
    private float mEndZoom;

    public Zoomer(Context context) {
        this.mAnimationDurationMillis = context.getResources().getInteger(0x10E0000);
    }

    public void forceFinished(boolean finished) {
        this.mFinished = finished;
    }

    public void abortAnimation() {
        this.mFinished = true;
        this.mCurrentZoom = this.mEndZoom;
    }

    public void startZoom(float endZoom) {
        this.mStartRTC = SystemClock.elapsedRealtime();
        this.mEndZoom = endZoom;
        this.mFinished = false;
        this.mCurrentZoom = 1.0f;
    }

    public boolean computeZoom() {
        if (this.mFinished) {
            return false;
        }
        long tRTC = SystemClock.elapsedRealtime() - this.mStartRTC;
        if (tRTC >= (long)this.mAnimationDurationMillis) {
            this.mFinished = true;
            this.mCurrentZoom = this.mEndZoom;
            return false;
        }
        float t = (float)tRTC * 1.0f / (float)this.mAnimationDurationMillis;
        this.mCurrentZoom = this.mEndZoom * this.mInterpolator.getInterpolation(t);
        return true;
    }

    public float getCurrZoom() {
        return this.mCurrentZoom;
    }
}

