/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart2.renderer;

import android.graphics.Canvas;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import cn.jingzhuan.lib.chart2.Viewport;
import cn.jingzhuan.lib.chart2.base.Chart;
import cn.jingzhuan.lib.chart2.component.Highlight;
import cn.jingzhuan.lib.chart2.data.AbstractDataSet;
import cn.jingzhuan.lib.chart2.data.BarDataSet;
import cn.jingzhuan.lib.chart2.data.CandlestickDataSet;
import cn.jingzhuan.lib.chart2.data.ChartData;
import cn.jingzhuan.lib.chart2.data.CombineData;
import cn.jingzhuan.lib.chart2.data.LineDataSet;
import cn.jingzhuan.lib.chart2.data.ScatterDataSet;
import cn.jingzhuan.lib.chart2.event.OnViewportChangeListener;
import cn.jingzhuan.lib.chart2.renderer.AbstractDataRenderer;
import cn.jingzhuan.lib.chart2.renderer.BarChartRenderer;
import cn.jingzhuan.lib.chart2.renderer.CandlestickChartRenderer;
import cn.jingzhuan.lib.chart2.renderer.LineRenderer;
import cn.jingzhuan.lib.chart2.renderer.ScatterChartRenderer;
import java.util.List;

public class CombineChartRenderer
extends AbstractDataRenderer {
    protected BarChartRenderer barChartRenderer;
    protected LineRenderer lineRenderer;
    protected CandlestickChartRenderer candlestickChartRenderer;
    protected ScatterChartRenderer scatterChartRenderer;
    private CombineData combineData;

    public CombineChartRenderer(Chart chart) {
        super(chart);
        this.lineRenderer = new LineRenderer(chart);
        this.barChartRenderer = new BarChartRenderer(chart);
        this.candlestickChartRenderer = new CandlestickChartRenderer(chart);
        this.scatterChartRenderer = new ScatterChartRenderer(chart);
        chart.setInternalViewportChangeListener(new OnViewportChangeListener(){

            @Override
            public void onViewportChange(Viewport viewport) {
                CombineChartRenderer.this.mViewport.set(viewport);
                CombineChartRenderer.this.calcDataSetMinMax();
            }
        });
    }

    @Override
    protected void renderDataSet(Canvas canvas) {
        this.barChartRenderer.renderDataSet(canvas, this.getChartData().getBarChartData());
        this.candlestickChartRenderer.renderDataSet(canvas, this.getChartData().getCandlestickChartData());
        this.lineRenderer.renderDataSet(canvas, this.getChartData().getLineChartData());
        this.scatterChartRenderer.renderDataSet(canvas, this.getChartData().getScatterChartData());
    }

    protected void renderDataSet(Canvas canvas, ChartData chartData) {
    }

    @Override
    public void setHighlightColor(int highlightColor) {
        super.setHighlightColor(highlightColor);
        this.lineRenderer.setHighlightColor(highlightColor);
        this.barChartRenderer.setHighlightColor(highlightColor);
        this.candlestickChartRenderer.setHighlightColor(highlightColor);
        this.scatterChartRenderer.setHighlightColor(highlightColor);
    }

    @Override
    public void renderHighlighted(Canvas canvas, @NonNull Highlight[] highlights) {
        if (this.lineRenderer.getDataSet() != null && !this.lineRenderer.getDataSet().isEmpty()) {
            this.lineRenderer.renderHighlighted(canvas, highlights);
        }
        if (this.barChartRenderer.getDataSet() != null && !this.barChartRenderer.getDataSet().isEmpty()) {
            this.barChartRenderer.renderHighlighted(canvas, highlights);
        }
        if (this.candlestickChartRenderer.getDataSet() != null && !this.candlestickChartRenderer.getDataSet().isEmpty()) {
            this.candlestickChartRenderer.renderHighlighted(canvas, highlights);
        }
        if (this.scatterChartRenderer.getDataSet() != null && !this.scatterChartRenderer.getDataSet().isEmpty()) {
            this.scatterChartRenderer.renderHighlighted(canvas, highlights);
        }
    }

    public void addDataSet(AbstractDataSet dataSet) {
        this.getChartData().add(dataSet);
        if (dataSet instanceof LineDataSet) {
            this.lineRenderer.addDataSet((LineDataSet)dataSet);
        } else if (dataSet instanceof BarDataSet) {
            this.barChartRenderer.addDataSet((BarDataSet)dataSet);
        } else if (dataSet instanceof CandlestickDataSet) {
            this.candlestickChartRenderer.addDataSet((CandlestickDataSet)dataSet);
        } else if (dataSet instanceof ScatterDataSet) {
            this.scatterChartRenderer.addDataSet((ScatterDataSet)dataSet);
        }
        this.calcDataSetMinMax();
    }

    @Override
    public void setDefaultVisibleEntryCount(int defaultVisibleEntryCount) {
        if (defaultVisibleEntryCount <= 0) {
            return;
        }
        this.barChartRenderer.setDefaultVisibleEntryCount(defaultVisibleEntryCount);
        this.lineRenderer.setDefaultVisibleEntryCount(defaultVisibleEntryCount);
        this.scatterChartRenderer.setDefaultVisibleEntryCount(defaultVisibleEntryCount);
        this.candlestickChartRenderer.setDefaultVisibleEntryCount(defaultVisibleEntryCount);
    }

    @Override
    public void setMaxVisibleEntryCount(int maxVisibleEntryCount) {
        if (maxVisibleEntryCount <= 0) {
            return;
        }
        this.barChartRenderer.setMaxVisibleEntryCount(maxVisibleEntryCount);
        this.lineRenderer.setMaxVisibleEntryCount(maxVisibleEntryCount);
        this.scatterChartRenderer.setMaxVisibleEntryCount(maxVisibleEntryCount);
        this.candlestickChartRenderer.setMaxVisibleEntryCount(maxVisibleEntryCount);
    }

    @Override
    public void setMinVisibleEntryCount(int minVisibleEntryCount) {
        if (minVisibleEntryCount <= 0) {
            return;
        }
        this.barChartRenderer.setMinVisibleEntryCount(minVisibleEntryCount);
        this.lineRenderer.setMinVisibleEntryCount(minVisibleEntryCount);
        this.scatterChartRenderer.setMinVisibleEntryCount(minVisibleEntryCount);
        this.candlestickChartRenderer.setMinVisibleEntryCount(minVisibleEntryCount);
    }

    public void removeDataSet(AbstractDataSet dataSet) {
        this.getChartData().remove(dataSet);
        this.calcDataSetMinMax();
    }

    @Override
    public void clearDataSet() {
        this.getChartData().clear();
        this.cleanLineDataSet();
        this.cleanBarDataSet();
        this.cleanCandlestickDataSet();
        this.cleanScatterDataSet();
        this.calcDataSetMinMax();
    }

    public void cleanLineDataSet() {
        this.lineRenderer.clearDataSet();
        this.getChartData().getLineChartData().clear();
    }

    public void cleanBarDataSet() {
        this.barChartRenderer.clearDataSet();
        this.getChartData().getBarChartData().clear();
    }

    public void cleanCandlestickDataSet() {
        this.candlestickChartRenderer.clearDataSet();
        this.getChartData().getCandlestickChartData().clear();
    }

    public void cleanScatterDataSet() {
        this.scatterChartRenderer.clearDataSet();
        this.getChartData().getScatterChartData().clear();
    }

    protected List<AbstractDataSet> getDataSet() {
        return this.combineData.getDataSets();
    }

    public CombineData getChartData() {
        if (this.combineData == null) {
            this.combineData = new CombineData();
        }
        return this.combineData;
    }

    @Override
    public void enableHighlightDashPathEffect(float[] intervals, float phase) {
        super.enableHighlightDashPathEffect(intervals, phase);
        this.lineRenderer.enableHighlightDashPathEffect(intervals, phase);
        this.barChartRenderer.enableHighlightDashPathEffect(intervals, phase);
        this.candlestickChartRenderer.enableHighlightDashPathEffect(intervals, phase);
        this.scatterChartRenderer.enableHighlightDashPathEffect(intervals, phase);
    }

    @Override
    public void setTypeface(Typeface tf) {
        this.lineRenderer.setTypeface(tf);
        this.barChartRenderer.setTypeface(tf);
        this.candlestickChartRenderer.setTypeface(tf);
        this.scatterChartRenderer.setTypeface(tf);
    }

    @Override
    public int getEntryIndexByCoordinate(float x, float y) {
        if (!this.getChartData().getCandlestickData().isEmpty()) {
            return this.candlestickChartRenderer.getEntryIndexByCoordinate(x, y);
        }
        if (!this.getChartData().getLineData().isEmpty()) {
            return this.lineRenderer.getEntryIndexByCoordinate(x, y);
        }
        if (!this.getChartData().getBarData().isEmpty()) {
            return this.barChartRenderer.getEntryIndexByCoordinate(x, y);
        }
        if (!this.getChartData().getScatterData().isEmpty()) {
            return this.scatterChartRenderer.getEntryIndexByCoordinate(x, y);
        }
        return super.getEntryIndexByCoordinate(x, y);
    }
}

