/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart2.animation;

import android.animation.TimeInterpolator;

public class Easing {
    private static final float DOUBLE_PI = (float)Math.PI * 2;
    public static final EasingFunction Linear = new EasingFunction(){

        @Override
        public float getInterpolation(float input) {
            return input;
        }
    };
    public static final EasingFunction EaseInQuad = new EasingFunction(){

        @Override
        public float getInterpolation(float input) {
            return input * input;
        }
    };
    public static final EasingFunction EaseOutQuad = new EasingFunction(){

        @Override
        public float getInterpolation(float input) {
            return -input * (input - 2.0f);
        }
    };
    public static final EasingFunction EaseInOutQuad = new EasingFunction(){

        @Override
        public float getInterpolation(float input) {
            if ((input *= 2.0f) < 1.0f) {
                return 0.5f * input * input;
            }
            return -0.5f * ((input -= 1.0f) * (input - 2.0f) - 1.0f);
        }
    };
    public static final EasingFunction EaseInCubic = new EasingFunction(){

        @Override
        public float getInterpolation(float input) {
            return (float)Math.pow(input, 3.0);
        }
    };
    public static final EasingFunction EaseOutCubic = new EasingFunction(){

        @Override
        public float getInterpolation(float input) {
            return (float)Math.pow(input -= 1.0f, 3.0) + 1.0f;
        }
    };
    public static final EasingFunction EaseInOutCubic = new EasingFunction(){

        @Override
        public float getInterpolation(float input) {
            if ((input *= 2.0f) < 1.0f) {
                return 0.5f * (float)Math.pow(input, 3.0);
            }
            return 0.5f * ((float)Math.pow(input -= 2.0f, 3.0) + 2.0f);
        }
    };
    public static final EasingFunction EaseInQuart = new EasingFunction(){

        @Override
        public float getInterpolation(float input) {
            return (float)Math.pow(input, 4.0);
        }
    };
    public static final EasingFunction EaseOutQuart = new EasingFunction(){

        @Override
        public float getInterpolation(float input) {
            return -((float)Math.pow(input -= 1.0f, 4.0) - 1.0f);
        }
    };
    public static final EasingFunction EaseInOutQuart = new EasingFunction(){

        @Override
        public float getInterpolation(float input) {
            if ((input *= 2.0f) < 1.0f) {
                return 0.5f * (float)Math.pow(input, 4.0);
            }
            return -0.5f * ((float)Math.pow(input -= 2.0f, 4.0) - 2.0f);
        }
    };
    public static final EasingFunction EaseInSine = new EasingFunction(){

        @Override
        public float getInterpolation(float input) {
            return -((float)Math.cos((double)input * 1.5707963267948966)) + 1.0f;
        }
    };
    public static final EasingFunction EaseOutSine = new EasingFunction(){

        @Override
        public float getInterpolation(float input) {
            return (float)Math.sin((double)input * 1.5707963267948966);
        }
    };
    public static final EasingFunction EaseInOutSine = new EasingFunction(){

        @Override
        public float getInterpolation(float input) {
            return -0.5f * ((float)Math.cos(Math.PI * (double)input) - 1.0f);
        }
    };
    public static final EasingFunction EaseInExpo = new EasingFunction(){

        @Override
        public float getInterpolation(float input) {
            return input == 0.0f ? 0.0f : (float)Math.pow(2.0, 10.0f * (input - 1.0f));
        }
    };
    public static final EasingFunction EaseOutExpo = new EasingFunction(){

        @Override
        public float getInterpolation(float input) {
            return input == 1.0f ? 1.0f : -((float)Math.pow(2.0, -10.0f * (input + 1.0f)));
        }
    };
    public static final EasingFunction EaseInOutExpo = new EasingFunction(){

        @Override
        public float getInterpolation(float input) {
            if (input == 0.0f) {
                return 0.0f;
            }
            if (input == 1.0f) {
                return 1.0f;
            }
            if ((input *= 2.0f) < 1.0f) {
                return 0.5f * (float)Math.pow(2.0, 10.0f * (input - 1.0f));
            }
            return 0.5f * (-((float)Math.pow(2.0, -10.0f * (input -= 1.0f))) + 2.0f);
        }
    };
    public static final EasingFunction EaseInCirc = new EasingFunction(){

        @Override
        public float getInterpolation(float input) {
            return -((float)Math.sqrt(1.0f - input * input) - 1.0f);
        }
    };
    public static final EasingFunction EaseOutCirc = new EasingFunction(){

        @Override
        public float getInterpolation(float input) {
            return (float)Math.sqrt(1.0f - (input -= 1.0f) * input);
        }
    };
    public static final EasingFunction EaseInOutCirc = new EasingFunction(){

        @Override
        public float getInterpolation(float input) {
            if ((input *= 2.0f) < 1.0f) {
                return -0.5f * ((float)Math.sqrt(1.0f - input * input) - 1.0f);
            }
            return 0.5f * ((float)Math.sqrt(1.0f - (input -= 2.0f) * input) + 1.0f);
        }
    };
    public static final EasingFunction EaseInElastic = new EasingFunction(){

        @Override
        public float getInterpolation(float input) {
            if (input == 0.0f) {
                return 0.0f;
            }
            if (input == 1.0f) {
                return 1.0f;
            }
            float p = 0.3f;
            float s = p / ((float)Math.PI * 2) * (float)Math.asin(1.0);
            return -((float)Math.pow(2.0, 10.0f * (input -= 1.0f)) * (float)Math.sin((input - s) * ((float)Math.PI * 2) / p));
        }
    };
    public static final EasingFunction EaseOutElastic = new EasingFunction(){

        @Override
        public float getInterpolation(float input) {
            if (input == 0.0f) {
                return 0.0f;
            }
            if (input == 1.0f) {
                return 1.0f;
            }
            float p = 0.3f;
            float s = p / ((float)Math.PI * 2) * (float)Math.asin(1.0);
            return 1.0f + (float)Math.pow(2.0, -10.0f * input) * (float)Math.sin((input - s) * ((float)Math.PI * 2) / p);
        }
    };
    public static final EasingFunction EaseInOutElastic = new EasingFunction(){

        @Override
        public float getInterpolation(float input) {
            if (input == 0.0f) {
                return 0.0f;
            }
            if ((input *= 2.0f) == 2.0f) {
                return 1.0f;
            }
            float p = 2.2222223f;
            float s = 0.07161972f * (float)Math.asin(1.0);
            if (input < 1.0f) {
                return -0.5f * ((float)Math.pow(2.0, 10.0f * (input -= 1.0f)) * (float)Math.sin((input * 1.0f - s) * ((float)Math.PI * 2) * p));
            }
            return 1.0f + 0.5f * (float)Math.pow(2.0, -10.0f * (input -= 1.0f)) * (float)Math.sin((input * 1.0f - s) * ((float)Math.PI * 2) * p);
        }
    };
    public static final EasingFunction EaseInBack = new EasingFunction(){

        @Override
        public float getInterpolation(float input) {
            float s = 1.70158f;
            return input * input * (2.70158f * input - 1.70158f);
        }
    };
    public static final EasingFunction EaseOutBack = new EasingFunction(){

        @Override
        public float getInterpolation(float input) {
            float s = 1.70158f;
            return (input -= 1.0f) * input * (2.70158f * input + 1.70158f) + 1.0f;
        }
    };
    public static final EasingFunction EaseInOutBack = new EasingFunction(){

        @Override
        public float getInterpolation(float input) {
            float s = 1.70158f;
            if ((input *= 2.0f) < 1.0f) {
                return 0.5f * (input * input * (((s *= 1.525f) + 1.0f) * input - s));
            }
            return 0.5f * ((input -= 2.0f) * input * (((s *= 1.525f) + 1.0f) * input + s) + 2.0f);
        }
    };
    public static final EasingFunction EaseInBounce = new EasingFunction(){

        @Override
        public float getInterpolation(float input) {
            return 1.0f - EaseOutBounce.getInterpolation(1.0f - input);
        }
    };
    public static final EasingFunction EaseOutBounce = new EasingFunction(){

        @Override
        public float getInterpolation(float input) {
            float s = 7.5625f;
            if (input < 0.36363637f) {
                return s * input * input;
            }
            if (input < 0.72727275f) {
                return s * (input -= 0.54545456f) * input + 0.75f;
            }
            if (input < 0.90909094f) {
                return s * (input -= 0.8181818f) * input + 0.9375f;
            }
            return s * (input -= 0.95454544f) * input + 0.984375f;
        }
    };
    public static final EasingFunction EaseInOutBounce = new EasingFunction(){

        @Override
        public float getInterpolation(float input) {
            if (input < 0.5f) {
                return EaseInBounce.getInterpolation(input * 2.0f) * 0.5f;
            }
            return EaseOutBounce.getInterpolation(input * 2.0f - 1.0f) * 0.5f + 0.5f;
        }
    };

    public static interface EasingFunction
    extends TimeInterpolator {
        public float getInterpolation(float var1);
    }
}

