/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart2.renderer;

import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import cn.jingzhuan.lib.chart2.Viewport;
import cn.jingzhuan.lib.chart2.base.Chart;
import cn.jingzhuan.lib.chart2.component.Highlight;
import cn.jingzhuan.lib.chart2.data.BarData;
import cn.jingzhuan.lib.chart2.data.BarDataSet;
import cn.jingzhuan.lib.chart2.data.BarValue;
import cn.jingzhuan.lib.chart2.data.ChartData;
import cn.jingzhuan.lib.chart2.data.ValueFormatter;
import cn.jingzhuan.lib.chart2.event.OnViewportChangeListener;
import cn.jingzhuan.lib.chart2.renderer.AbstractDataRenderer;
import cn.jingzhuan.lib.chart2.utils.FloatUtils;
import java.util.List;

public class BarChartRenderer
extends AbstractDataRenderer<BarDataSet> {
    private BarData mBarDataSets;
    private final char[] mLabelBuffer = new char[100];
    private Paint mValueTextPaint = new Paint(1);

    public BarChartRenderer(final Chart chart) {
        super(chart);
        this.mValueTextPaint.setStyle(Paint.Style.FILL);
        chart.setInternalViewportChangeListener(new OnViewportChangeListener(){

            @Override
            public void onViewportChange(Viewport viewport) {
                BarChartRenderer.this.mViewport.set(viewport);
                BarChartRenderer.this.calcDataSetMinMax();
            }
        });
        final Highlight highlight = new Highlight();
        chart.addOnTouchPointChangeListener(new Chart.OnTouchPointChangeListener(){

            @Override
            public void touch(float x, float y) {
                if (chart.isHighlightDisable()) {
                    return;
                }
                for (BarDataSet dataSet : BarChartRenderer.this.getDataSet()) {
                    if (!dataSet.isHighlightedVerticalEnable()) continue;
                    highlight.setTouchX(x);
                    highlight.setTouchY(y);
                    int index = BarChartRenderer.this.getEntryIndexByCoordinate(x, y) - dataSet.getStartIndexOffset();
                    if (index >= dataSet.getValues().size()) continue;
                    BarValue barValue = dataSet.getEntryForIndex(index);
                    float xPosition = barValue.getX();
                    float yPosition = barValue.getY();
                    if (!(xPosition >= 0.0f) || !(yPosition >= 0.0f)) continue;
                    highlight.setX(xPosition);
                    highlight.setY(yPosition);
                    highlight.setDataIndex(index);
                    chart.highlightValue(highlight);
                }
            }
        });
    }

    @Override
    protected void renderDataSet(Canvas canvas, ChartData<BarDataSet> chartData) {
        for (BarDataSet dataSet : chartData.getDataSets()) {
            if (!dataSet.isVisible()) continue;
            this.drawBarDataSet(canvas, dataSet, chartData.getLeftMax(), chartData.getLeftMin(), chartData.getRightMax(), chartData.getRightMin());
        }
    }

    private void drawBarDataSet(Canvas canvas, BarDataSet barDataSet, float lMax, float lMin, float rMax, float rMin) {
        float max;
        float min;
        this.mRenderPaint.setStrokeWidth(barDataSet.getStrokeThickness());
        this.mRenderPaint.setStyle(Paint.Style.FILL);
        this.mValueTextPaint.setColor(barDataSet.getValueColor());
        this.mValueTextPaint.setTextSize(barDataSet.getValueTextSize());
        int valueCount = barDataSet.getEntryCount();
        switch (barDataSet.getAxisDependency()) {
            case 24: {
                min = rMin;
                max = rMax;
                break;
            }
            default: {
                min = lMin;
                max = lMax;
            }
        }
        float width = barDataSet.getBarWidth();
        float visibleRange = barDataSet.getVisibleRange(this.mViewport);
        if (barDataSet.isAutoBarWidth() && visibleRange > 0.0f) {
            width = (float)this.mContentRect.width() / visibleRange;
        }
        float percent = barDataSet.getBarWidthPercent();
        float scale = 1.0f / this.mViewport.width();
        float step = (float)this.mContentRect.width() * scale / (float)valueCount;
        float startX = (float)this.mContentRect.left - this.mViewport.left * (float)this.mContentRect.width() * scale;
        for (int i = 0; i < valueCount && i < barDataSet.getValues().size(); ++i) {
            BarValue barValue = barDataSet.getEntryForIndex(i);
            if (!barValue.isEnable() || barValue.getValues().length < 1 || Float.isNaN(barValue.getValues()[0])) continue;
            if (barValue.getColor() != -2) {
                this.mRenderPaint.setColor(barValue.getColor());
            } else {
                this.mRenderPaint.setColor(barDataSet.getColor());
            }
            float x = startX + step * (float)(i + barDataSet.getStartIndexOffset());
            float bottom = this.calcHeight(0.0f, max, min);
            if (barValue.getValueCount() > 0) {
                float value = barValue.getValues()[0] * this.mChartAnimator.getPhaseY();
                float top = this.calcHeight(value, max, min);
                if (barValue.getValueCount() > 1) {
                    bottom = this.calcHeight(barValue.getValues()[1], max, min);
                }
                barValue.setCoordinate(x + width * 0.5f, top);
                this.mRenderPaint.setStyle(barValue.getPaintStyle());
                float left = x + width * (1.0f - percent) * 0.5f;
                float right = left + width * percent;
                if ((double)Math.abs(top - bottom) < 1.0E-4) {
                    canvas.drawLine(left, top, right, bottom, this.mRenderPaint);
                } else {
                    if (barValue.getGradientColors() != null && barValue.getGradientColors().length > 1) {
                        float centerX = (left + right) * 0.5f;
                        this.mRenderPaint.setShader((Shader)new LinearGradient(centerX, top, centerX, bottom, barValue.getGradientColors()[0], barValue.getGradientColors()[1], Shader.TileMode.MIRROR));
                    }
                    canvas.drawRect(left, top, right, bottom, this.mRenderPaint);
                }
                if (barDataSet.isDrawValueEnable()) {
                    int labelLength;
                    ValueFormatter valueFormatter = barDataSet.getValueFormatter();
                    if (valueFormatter == null) {
                        labelLength = FloatUtils.formatFloatValue(this.mLabelBuffer, value, 2);
                    } else {
                        char[] labelCharArray = valueFormatter.format(barValue.getValues()[0], i).toCharArray();
                        labelLength = labelCharArray.length;
                        System.arraycopy(labelCharArray, 0, this.mLabelBuffer, this.mLabelBuffer.length - labelLength, labelLength);
                    }
                    int labelOffset = this.mLabelBuffer.length - labelLength;
                    this.mValueTextPaint.setTextAlign(Paint.Align.CENTER);
                    canvas.drawText(this.mLabelBuffer, labelOffset, labelLength, x + width * 0.5f, top - 10.0f, this.mValueTextPaint);
                }
            }
            this.mRenderPaint.setShader(null);
        }
        this.mRenderPaint.setStyle(Paint.Style.FILL);
    }

    private float calcHeight(float value, float max, float min) {
        if (Float.compare(max, min) == 0) {
            return 0.0f;
        }
        return (max - value) / (max - min) * (float)this.mContentRect.height();
    }

    @Override
    public void renderHighlighted(Canvas canvas, @NonNull Highlight[] highlights) {
        this.mRenderPaint.setColor(this.getHighlightColor());
        this.mRenderPaint.setStrokeWidth(2.0f);
        this.mRenderPaint.setStyle(Paint.Style.STROKE);
        if (this.mHighlightedDashPathEffect != null) {
            this.mRenderPaint.setPathEffect((PathEffect)this.mHighlightedDashPathEffect);
        }
        for (Highlight highlight : highlights) {
            canvas.drawLine(highlight.getX(), 0.0f, highlight.getX(), (float)this.mContentRect.bottom, this.mRenderPaint);
        }
        this.mRenderPaint.setPathEffect(null);
    }

    @Override
    public void removeDataSet(BarDataSet dataSet) {
        if (dataSet == null) {
            return;
        }
        this.mBarDataSets.remove(dataSet);
        this.calcDataSetMinMax();
    }

    @Override
    public void clearDataSet() {
        this.mBarDataSets.clear();
        this.calcDataSetMinMax();
    }

    @Override
    protected List<BarDataSet> getDataSet() {
        return this.mBarDataSets.getDataSets();
    }

    public BarData getChartData() {
        if (this.mBarDataSets == null) {
            this.mBarDataSets = new BarData();
        }
        return this.mBarDataSets;
    }

    @Override
    public void setTypeface(Typeface tf) {
        this.mValueTextPaint.setTypeface(tf);
    }
}

