/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.renderer;

import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import cn.jingzhuan.lib.chart.base.Chart;
import cn.jingzhuan.lib.chart.component.Highlight;
import cn.jingzhuan.lib.chart.data.ChartData;
import cn.jingzhuan.lib.chart.data.ScatterData;
import cn.jingzhuan.lib.chart.data.ScatterDataSet;
import cn.jingzhuan.lib.chart.data.ScatterValue;
import cn.jingzhuan.lib.chart.renderer.AbstractDataRenderer;
import cn.jingzhuan.lib.chart.renderer.TextValueRenderer;
import java.util.List;

public class ScatterChartRenderer
extends AbstractDataRenderer<ScatterDataSet> {
    private ScatterData scatterData;

    public ScatterChartRenderer(Chart chart) {
        super(chart);
    }

    @Override
    protected void renderDataSet(Canvas canvas, ChartData<ScatterDataSet> chartData) {
        for (ScatterDataSet dataSet : this.getDataSet()) {
            if (!dataSet.isVisible()) continue;
            this.drawDataSet(canvas, dataSet, chartData.getLeftMax(), chartData.getLeftMin(), chartData.getRightMax(), chartData.getRightMin());
        }
    }

    private void drawDataSet(Canvas canvas, ScatterDataSet dataSet, float leftMax, float leftMin, float rightMax, float rightMin) {
        float max;
        float min;
        this.mRenderPaint.setStrokeWidth(2.0f);
        this.mRenderPaint.setColor(dataSet.getColor());
        int valueCount = dataSet.getEntryCount();
        switch (dataSet.getAxisDependency()) {
            case 24: {
                min = rightMin;
                max = rightMax;
                break;
            }
            default: {
                min = leftMin;
                max = leftMax;
            }
        }
        float width = ((float)this.mContentRect.width() - dataSet.getStartXOffset() - dataSet.getEndXOffset()) / dataSet.getVisibleRange(this.mViewport) + 1.0f;
        float shapeWidth = dataSet.getShape().getIntrinsicWidth();
        float shapeHeight = dataSet.getShape().getIntrinsicHeight();
        if (dataSet.isAutoWidth()) {
            shapeWidth = width * 0.8f;
            shapeHeight = shapeWidth * shapeHeight / (float)dataSet.getShape().getIntrinsicWidth();
        }
        for (int i = 0; i < valueCount && i < dataSet.getValues().size() && dataSet.getShape() != null; ++i) {
            ScatterValue point = dataSet.getEntryForIndex(i);
            if (!point.isVisible()) continue;
            float xPosition = dataSet.getStartXOffset() + width * 0.5f + this.getDrawX((float)(i + dataSet.getStartIndexOffset()) / (float)valueCount) - shapeWidth * 0.5f;
            float yPosition = (max - point.getValue()) / (max - min) * (float)this.mContentRect.height() - shapeHeight * 0.5f;
            point.setCoordinate(xPosition, yPosition);
            int x = (int)(xPosition + dataSet.getDrawOffsetX());
            int y = (int)(yPosition + dataSet.getDrawOffsetY());
            if (point.getColor() != 0) {
                dataSet.getShape().setColorFilter(point.getColor(), PorterDuff.Mode.SRC_OVER);
            }
            dataSet.getShape().setBounds(x, y, (int)((float)x + shapeWidth), (int)((float)y + shapeHeight));
            int saveId = canvas.save();
            dataSet.getShape().draw(canvas);
            canvas.restoreToCount(saveId);
            if (dataSet.getTextValueRenderers() == null) continue;
            for (TextValueRenderer textValueRenderer : dataSet.getTextValueRenderers()) {
                textValueRenderer.render(canvas, i, (float)x + shapeWidth * 0.5f, (float)y + shapeHeight * 0.5f);
            }
        }
    }

    @Override
    public int getEntryIndexByCoordinate(float x, float y) {
        int index = -1;
        if (this.scatterData.getDataSets().size() > 0) {
            ScatterDataSet dataSet = (ScatterDataSet)this.scatterData.getDataSets().get(0);
            RectF rect = new RectF();
            float shapeWidth = dataSet.getShape().getIntrinsicWidth();
            float shapeHeight = dataSet.getShape().getIntrinsicHeight();
            for (int i = 0; i < dataSet.getValues().size(); ++i) {
                ScatterValue value = dataSet.getEntryForIndex(i);
                float pX = value.getX();
                float pY = value.getY();
                rect.set(pX, pY, pX + shapeWidth, pY + shapeHeight);
                if (!rect.contains(x, y)) continue;
                index = i;
                break;
            }
            return index;
        }
        return super.getEntryIndexByCoordinate(x, y);
    }

    @Override
    public void renderHighlighted(Canvas canvas, @NonNull Highlight[] highlights) {
    }

    @Override
    public void removeDataSet(ScatterDataSet dataSet) {
        this.getChartData().remove(dataSet);
        this.calcDataSetMinMax();
    }

    @Override
    public void clearDataSet() {
        this.getChartData().clear();
    }

    @Override
    protected List<ScatterDataSet> getDataSet() {
        return this.getChartData().getDataSets();
    }

    @Override
    public ChartData<ScatterDataSet> getChartData() {
        if (this.scatterData == null) {
            this.scatterData = new ScatterData();
        }
        return this.scatterData;
    }
}

