/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.base;

import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.view.MotionEvent;
import cn.jingzhuan.lib.chart.animation.ChartAnimator;
import cn.jingzhuan.lib.chart.animation.Easing;
import cn.jingzhuan.lib.chart.base.Chart;
import cn.jingzhuan.lib.chart.component.Highlight;
import cn.jingzhuan.lib.chart.event.HighlightStatusChangeListener;
import cn.jingzhuan.lib.chart.event.OnHighlightListener;
import cn.jingzhuan.lib.chart.renderer.AbstractDataRenderer;
import cn.jingzhuan.lib.chart.renderer.AxisRenderer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class BaseChart
extends Chart {
    protected AbstractDataRenderer mRenderer;
    private List<AxisRenderer> mAxisRenderers;
    protected Highlight[] mHighlights;
    private HighlightStatusChangeListener mHighlightStatusChangeListener;
    private OnHighlightListener mHighlightListener;
    protected WeakReference<Bitmap> mDrawBitmap;
    protected Canvas mBitmapCanvas;
    protected Bitmap.Config mBitmapConfig = Bitmap.Config.ARGB_8888;
    private ChartAnimator mChartAnimator;

    public BaseChart(Context context) {
        super(context);
    }

    public BaseChart(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public BaseChart(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @RequiresApi(api=21)
    public BaseChart(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    public void initChart() {
        this.mAxisRenderers = new ArrayList<AxisRenderer>(4);
        this.mAxisRenderers.add(new AxisRenderer(this, this.mAxisTop));
        this.mAxisRenderers.add(new AxisRenderer(this, this.mAxisBottom));
        this.mAxisRenderers.add(new AxisRenderer(this, this.mAxisLeft));
        this.mAxisRenderers.add(new AxisRenderer(this, this.mAxisRight));
        this.mChartAnimator = new ChartAnimator(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BaseChart.this.postInvalidate();
            }
        });
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mBitmapCanvas != null) {
            this.mBitmapCanvas.setBitmap(null);
            this.mBitmapCanvas = null;
        }
        if (this.mDrawBitmap != null) {
            if (this.mDrawBitmap.get() != null) {
                ((Bitmap)this.mDrawBitmap.get()).recycle();
            }
            this.mDrawBitmap.clear();
            this.mDrawBitmap = null;
        }
    }

    @Override
    protected void createBitmapCache(Canvas canvas) {
        int width = this.getContentRect().width() + this.getContentRect().left;
        int height = this.getContentRect().height();
        if (this.mDrawBitmap == null || ((Bitmap)this.mDrawBitmap.get()).getWidth() != width || ((Bitmap)this.mDrawBitmap.get()).getHeight() != height) {
            if (width > 0 && height > 0) {
                this.mDrawBitmap = new WeakReference<Bitmap>(Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)this.mBitmapConfig));
                this.mBitmapCanvas = new Canvas((Bitmap)this.mDrawBitmap.get());
            } else {
                return;
            }
        }
        ((Bitmap)this.mDrawBitmap.get()).eraseColor(0);
    }

    @Override
    protected Bitmap getDrawBitmap() {
        return (Bitmap)this.mDrawBitmap.get();
    }

    @Override
    protected Paint getRenderPaint() {
        return this.mRenderer.getRenderPaint();
    }

    @Override
    public Canvas getBitmapCanvas() {
        return this.mBitmapCanvas;
    }

    @Override
    protected void drawAxis(Canvas canvas) {
        for (AxisRenderer axisRenderer : this.mAxisRenderers) {
            axisRenderer.renderer(canvas);
        }
    }

    @Override
    protected void drawGridLine(Canvas canvas) {
        for (AxisRenderer axisRenderer : this.mAxisRenderers) {
            axisRenderer.drawGridLines(canvas);
        }
    }

    @Override
    protected void drawLabels(Canvas canvas) {
        for (AxisRenderer axisRenderer : this.mAxisRenderers) {
            axisRenderer.drawLabels(canvas);
        }
    }

    @Override
    protected void onTouchPoint(MotionEvent e) {
        if (e.getPointerCount() == 1) {
            for (Chart.OnTouchPointChangeListener touchPointChangeListener : this.mTouchPointChangeListeners) {
                touchPointChangeListener.touch(e.getX(), e.getY());
            }
        }
    }

    @Override
    public void highlightValue(Highlight highlight) {
        if (highlight == null) {
            return;
        }
        Highlight[] highlights = new Highlight[]{highlight};
        if (this.mHighlightStatusChangeListener != null) {
            this.mHighlightStatusChangeListener.onHighlightShow(highlights);
        }
        if (this.mHighlightListener != null) {
            this.mHighlightListener.highlight(highlights);
        }
        this.mHighlights = highlights;
        this.invalidate();
    }

    @Override
    public void cleanHighlight() {
        this.mHighlights = null;
        if (this.mHighlightStatusChangeListener != null) {
            this.mHighlightStatusChangeListener.onHighlightHide();
        }
        this.invalidate();
    }

    public void setRenderer(AbstractDataRenderer renderer) {
        this.mRenderer = renderer;
    }

    @Override
    protected final void render(Canvas canvas) {
        if (this.mRenderer != null) {
            this.mRenderer.renderer(canvas);
        }
        this.drawEdgeEffectsUnclipped(canvas);
        this.renderHighlighted(canvas);
    }

    public void renderHighlighted(Canvas canvas) {
        if (this.mRenderer != null && this.getHighlights() != null) {
            this.mRenderer.renderHighlighted(canvas, this.getHighlights());
        }
    }

    public void setHighlightColor(int color) {
        this.mRenderer.setHighlightColor(color);
    }

    public int getHighlightColor() {
        return this.mRenderer.getHighlightColor();
    }

    public Highlight[] getHighlights() {
        return this.mHighlights;
    }

    public void setHighlights(Highlight[] highlights) {
        this.mHighlights = highlights;
    }

    public void setOnHighlightStatusChangeListener(HighlightStatusChangeListener mHighlightStatusChangeListener) {
        this.mHighlightStatusChangeListener = mHighlightStatusChangeListener;
    }

    public HighlightStatusChangeListener getOnHighlightStatusChangeListener() {
        return this.mHighlightStatusChangeListener;
    }

    public void setOnHighlightListener(OnHighlightListener highlightListener) {
        this.mHighlightListener = highlightListener;
    }

    public void enableHighlightDashPathEffect(float[] intervals, float phase) {
        this.mRenderer.enableHighlightDashPathEffect(intervals, phase);
    }

    public void setMinVisibleEntryCount(int minVisibleEntryCount) {
        this.mRenderer.setMinVisibleEntryCount(minVisibleEntryCount);
    }

    public void setMaxVisibleEntryCount(int maxVisibleEntryCount) {
        this.mRenderer.setMaxVisibleEntryCount(maxVisibleEntryCount);
    }

    public void setDefaultVisibleEntryCount(int defaultVisibleEntryCount) {
        this.mRenderer.setDefaultVisibleEntryCount(defaultVisibleEntryCount);
    }

    @Override
    protected int getEntryIndexByCoordinate(float x, float y) {
        return this.mRenderer.getEntryIndexByCoordinate(x, y);
    }

    public void setTypeface(Typeface tf) {
        for (AxisRenderer mAxisRenderer : this.mAxisRenderers) {
            mAxisRenderer.setTypeface(tf);
        }
        this.postInvalidate();
    }

    @Override
    public void releaseBitmap() {
        if (this.mBitmapCanvas != null) {
            this.mBitmapCanvas.setBitmap(null);
            this.mBitmapCanvas = null;
        }
        if (this.mDrawBitmap != null) {
            if (this.mDrawBitmap.get() != null) {
                ((Bitmap)this.mDrawBitmap.get()).recycle();
            }
            this.mDrawBitmap.clear();
            this.mDrawBitmap = null;
        }
    }

    public ChartAnimator getChartAnimator() {
        return this.mChartAnimator;
    }

    public void animateXY(int durationMillisX, int durationMillisY, Easing.EasingFunction easingX, Easing.EasingFunction easingY) {
        this.mChartAnimator.animateXY(durationMillisX, durationMillisY, easingX, easingY);
    }

    public void animateXY(int durationMillisX, int durationMillisY, Easing.EasingFunction easing) {
        this.mChartAnimator.animateXY(durationMillisX, durationMillisY, easing);
    }

    public void animateX(int durationMillis, Easing.EasingFunction easing) {
        this.mChartAnimator.animateX(durationMillis, easing);
    }

    public void animateY(int durationMillis, Easing.EasingFunction easing) {
        this.mChartAnimator.animateY(durationMillis, easing);
    }

    public void animateX(int durationMillis) {
        this.mChartAnimator.animateX(durationMillis);
    }

    public void animateY(int durationMillis) {
        this.mChartAnimator.animateY(durationMillis);
    }

    public void animateXY(int durationMillisX, int durationMillisY) {
        this.mChartAnimator.animateXY(durationMillisX, durationMillisY);
    }
}

