/*
 * Decompiled with CFR 0.152.
 */
package cn.jiiiiiin.vplus.ui.refresh;

import androidx.annotation.NonNull;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DynamicTimeFormat
extends SimpleDateFormat {
    private static Locale locale = Locale.CHINA;
    private static String[] weeks = new String[]{"\u5468\u65e5", "\u5468\u4e00", "\u5468\u4e8c", "\u5468\u4e09", "\u5468\u56db", "\u5468\u4e94", "\u5468\u516d"};
    private static String[] moments = new String[]{"\u4e2d\u5348", "\u51cc\u6668", "\u65e9\u4e0a", "\u4e0b\u5348", "\u665a\u4e0a"};
    private String mFormat = "%s";

    public DynamicTimeFormat() {
        this("%s", "yyyy\u5e74", "M\u6708d\u65e5", "HH:mm");
    }

    public DynamicTimeFormat(String format) {
        this();
        this.mFormat = format;
    }

    public DynamicTimeFormat(String yearFormat, String dateFormat, String timeFormat) {
        super(String.format(locale, "%s %s %s", yearFormat, dateFormat, timeFormat), locale);
    }

    public DynamicTimeFormat(String format, String yearFormat, String dateFormat, String timeFormat) {
        this(yearFormat, dateFormat, timeFormat);
        this.mFormat = format;
    }

    @Override
    public StringBuffer format(@NonNull Date date, @NonNull StringBuffer toAppendTo, @NonNull FieldPosition pos) {
        boolean yearTemp;
        toAppendTo = super.format(date, toAppendTo, pos);
        Calendar otherCalendar = this.calendar;
        Calendar todayCalendar = Calendar.getInstance();
        int hour = otherCalendar.get(11);
        String[] times = toAppendTo.toString().split(" ");
        String moment = hour == 12 ? moments[0] : moments[hour / 6 + 1];
        String timeFormat = moment + " " + times[2];
        String dateFormat = times[1] + " " + timeFormat;
        String yearFormat = times[0] + dateFormat;
        toAppendTo.delete(0, toAppendTo.length());
        boolean bl = yearTemp = todayCalendar.get(1) == otherCalendar.get(1);
        if (yearTemp) {
            int otherMonth;
            int todayMonth = todayCalendar.get(2);
            if (todayMonth == (otherMonth = otherCalendar.get(2))) {
                int temp = todayCalendar.get(5) - otherCalendar.get(5);
                switch (temp) {
                    case 0: {
                        toAppendTo.append(timeFormat);
                        break;
                    }
                    case 1: {
                        toAppendTo.append("\u6628\u5929 ");
                        toAppendTo.append(timeFormat);
                        break;
                    }
                    case 2: {
                        toAppendTo.append("\u524d\u5929 ");
                        toAppendTo.append(timeFormat);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        int dayOfMonth = otherCalendar.get(4);
                        int todayOfMonth = todayCalendar.get(4);
                        if (dayOfMonth == todayOfMonth) {
                            int dayOfWeek = otherCalendar.get(7);
                            if (dayOfWeek != 1) {
                                toAppendTo.append(weeks[otherCalendar.get(7) - 1]);
                                toAppendTo.append(' ');
                                toAppendTo.append(timeFormat);
                                break;
                            }
                            toAppendTo.append(dateFormat);
                            break;
                        }
                        toAppendTo.append(dateFormat);
                        break;
                    }
                    default: {
                        toAppendTo.append(dateFormat);
                    }
                }
            } else {
                toAppendTo.append(dateFormat);
            }
        } else {
            toAppendTo.append(yearFormat);
        }
        int length = toAppendTo.length();
        toAppendTo.append(String.format(locale, this.mFormat, toAppendTo.toString()));
        toAppendTo.delete(0, length);
        return toAppendTo;
    }
}

