/*
 * Decompiled with CFR 0.152.
 */
package www.znq.com.myapplication.proxy;

import android.app.Activity;
import android.view.MotionEvent;
import android.view.View;
import android.widget.EditText;
import androidx.annotation.NonNull;
import www.znq.com.myapplication.util.KeyBoardUtils;

public class ActivityKeyBoardProxy {
    private final Activity mActivity;
    private final int[] mHideSoftByEditViewIds;
    private final View[] mFilterViewByIds;
    private final OnHideInputForceListener mOnHideInputForceListener;

    private ActivityKeyBoardProxy(@NonNull Activity activity, @NonNull int[] hideSoftByEditViewIds, View[] filterViewByIds, OnHideInputForceListener onHideInputForceListener) {
        this.mActivity = activity;
        this.mHideSoftByEditViewIds = hideSoftByEditViewIds;
        this.mFilterViewByIds = filterViewByIds;
        this.mOnHideInputForceListener = onHideInputForceListener;
    }

    public static ActivityKeyBoardProxy newInstance(@NonNull Activity activity, @NonNull int[] hideSoftByEditViewIds, View[] filterViewByIds, OnHideInputForceListener onHideInputForceListener) {
        if (filterViewByIds == null) {
            filterViewByIds = new View[]{};
        }
        return new ActivityKeyBoardProxy(activity, hideSoftByEditViewIds, filterViewByIds, onHideInputForceListener);
    }

    public void onDispatchTouchEvent(MotionEvent motionEvent) {
        if (motionEvent.getAction() == 0) {
            if (this.isTouchView(this.mFilterViewByIds, motionEvent) || this.mHideSoftByEditViewIds.length == 0) {
                return;
            }
            View v = this.mActivity.getCurrentFocus();
            if (this.isFocusEditText(v, this.mHideSoftByEditViewIds)) {
                if (this.isTouchView(this.mHideSoftByEditViewIds, motionEvent)) {
                    return;
                }
                KeyBoardUtils.hideInputForce(this.mActivity);
                this.clearViewFocus(v, this.mHideSoftByEditViewIds);
                if (this.mOnHideInputForceListener != null) {
                    this.mOnHideInputForceListener.onHideInputForce(motionEvent);
                }
            }
        }
    }

    public void clearViewFocus(View v, int ... ids) {
        if (null != v && null != ids && ids.length > 0) {
            for (int id2 : ids) {
                if (v.getId() != id2) continue;
                v.clearFocus();
                break;
            }
        }
    }

    private boolean isFocusEditText(View v, int ... ids) {
        if (v instanceof EditText) {
            EditText tmp_et = (EditText)v;
            for (int id2 : ids) {
                if (tmp_et.getId() != id2) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isTouchView(View[] views, MotionEvent motionEvent) {
        if (views == null || views.length == 0) {
            return false;
        }
        int[] location = new int[2];
        for (View view : views) {
            view.getLocationOnScreen(location);
            int x = location[0];
            int y = location[1];
            if (!(motionEvent.getX() > (float)x) || !(motionEvent.getX() < (float)(x + view.getWidth())) || !(motionEvent.getY() > (float)y) || !(motionEvent.getY() < (float)(y + view.getHeight()))) continue;
            return true;
        }
        return false;
    }

    private boolean isTouchView(int[] ids, MotionEvent motionEvent) {
        int[] location = new int[2];
        for (int id2 : ids) {
            View view = this.mActivity.findViewById(id2);
            if (view == null) continue;
            view.getLocationOnScreen(location);
            int x = location[0];
            int y = location[1];
            if (!(motionEvent.getX() > (float)x) || !(motionEvent.getX() < (float)(x + view.getWidth())) || !(motionEvent.getY() > (float)y) || !(motionEvent.getY() < (float)(y + view.getHeight()))) continue;
            return true;
        }
        return false;
    }

    public static interface OnHideInputForceListener {
        public void onHideInputForce(MotionEvent var1);
    }
}

