/*
 * Decompiled with CFR 0.152.
 */
package cn.jiiiiiin.vplus.core.webview.util;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.URLUtil;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import cn.jiiiiiin.vplus.core.app.ViewPlus;
import cn.jiiiiiin.vplus.core.util.log.LoggerProxy;
import com.blankj.utilcode.util.StringUtils;
import com.blankj.utilcode.util.ToastUtils;

public final class WebViewUtil {
    private static final String OPEN_SYSTEM_WEBVIEW_INTENT = "android.intent.action.VIEW";

    public static void startSystemWebViewApp(Activity activity, String url) {
        if (URLUtil.isHttpsUrl((String)url) || URLUtil.isHttpUrl((String)url)) {
            Intent intent = new Intent();
            intent.setAction(OPEN_SYSTEM_WEBVIEW_INTENT);
            Uri contentUrl = Uri.parse((String)url);
            intent.setData(contentUrl);
            activity.startActivity(intent);
        } else {
            ToastUtils.showLong((CharSequence)String.format("\u975e\u6cd5\u94fe\u63a5[%s]\uff0c\u4e0d\u80fd\u8fdb\u884c\u8df3\u8f6c\u3002", url));
        }
    }

    public static void clearWebViewCookies() {
        CookieManager cookieManager = CookieManager.getInstance();
        if (Build.VERSION.SDK_INT >= 21) {
            cookieManager.removeSessionCookies(value -> LoggerProxy.w("\u540c\u6b65\u4e4b\u524d\u79fb\u9664 removeSessionCookies %s", value));
            cookieManager.removeAllCookies(value -> LoggerProxy.w("\u540c\u6b65\u4e4b\u524d\u79fb\u9664removeAllCookies %s", value));
        }
    }

    public static void clearWebViewCache(WebView webView) {
        block5: {
            if (webView != null) {
                try {
                    try {
                        ViewPlus.getApplicationContext().deleteDatabase("webview.db");
                        ViewPlus.getApplicationContext().deleteDatabase("webviewCache.db");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    webView.clearCache(true);
                    webView.clearHistory();
                    webView.clearFormData();
                }
                catch (Exception e) {
                    if (!ViewPlus.IS_DEBUG()) break block5;
                    LoggerProxy.e("clearWebViewCache error %s", e.getMessage());
                }
            }
        }
    }

    public static void destroyWebView(WebView webview) {
        if (webview != null) {
            webview.stopLoading();
            webview.loadUrl("about:blank");
            ViewGroup containerView = (ViewGroup)webview.getParent();
            if (null != containerView) {
                containerView.removeView((View)webview);
                webview.removeAllViews();
                webview.destroy();
                webview = null;
            }
        }
    }

    public static boolean syncCookie(@NonNull String url, String cookie) {
        if (!StringUtils.isTrimEmpty((String)url)) {
            CookieManager cookieManager = CookieManager.getInstance();
            cookieManager.setAcceptCookie(true);
            WebViewUtil.clearWebViewCookies();
            if (ViewPlus.IS_DEBUG()) {
                LoggerProxy.d("\u540c\u6b65\u7684 url %s cookie %s", url, cookie);
            }
            cookieManager.setCookie(url, cookie);
            String newCookie = cookieManager.getCookie(url);
            return !TextUtils.isEmpty((CharSequence)newCookie);
        }
        return false;
    }

    public static String getCookie2Url(String url) {
        String cookieStr;
        CookieManager manager = CookieManager.getInstance();
        if (!TextUtils.isEmpty((CharSequence)url) && manager.hasCookies() && !TextUtils.isEmpty((CharSequence)(cookieStr = manager.getCookie(url)))) {
            return cookieStr;
        }
        return null;
    }

    private static void flush() {
        if (Build.VERSION.SDK_INT >= 21) {
            CookieManager.getInstance().flush();
        } else {
            CookieSyncManager.getInstance().sync();
        }
    }

    public static void removeCookie(String url) {
        CookieManager cm = CookieManager.getInstance();
        for (String cookie : cm.getCookie(url).split("; ")) {
            cm.setCookie(url, cookie.split("=")[0] + "=");
        }
        WebViewUtil.flush();
    }

    public static void remove(boolean sessionOnly) {
        CookieManager cm = CookieManager.getInstance();
        if (Build.VERSION.SDK_INT >= 21) {
            if (sessionOnly) {
                cm.removeSessionCookies(null);
            } else {
                cm.removeAllCookies(null);
            }
        } else if (sessionOnly) {
            cm.removeSessionCookie();
        } else {
            cm.removeAllCookie();
        }
        WebViewUtil.flush();
    }

    public static final boolean scrollInBottom(WebView webView) {
        return (float)webView.getContentHeight() * webView.getScale() == (float)(webView.getHeight() + webView.getScrollY());
    }

    public static final boolean scrollInTop(WebView webView) {
        return webView.getScrollY() == 0;
    }

    public static final void scroll2Top(WebView webView) {
        webView.pageUp(true);
    }

    public static final void scroll2Bottom(WebView webView) {
        webView.pageDown(true);
    }

    public static final void scroll2Refresh(WebView webView) {
        webView.reload();
    }
}

