/*
 * Decompiled with CFR 0.152.
 */
package cn.jiiiiiin.vplus.core.webview.util;

import android.app.Activity;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import cn.jiiiiiin.vplus.core.app.ViewPlus;
import cn.jiiiiiin.vplus.core.util.log.LoggerProxy;
import cn.jiiiiiin.vplus.core.util.ui.ViewUtil;
import cn.jiiiiiin.vplus.core.webview.AbstractWebViewDelegate;
import cn.jiiiiiin.vplus.core.webview.AbstractWebViewWrapperCommUIDelegate;
import cn.jiiiiiin.vplus.core.webview.WebViewDelegateImpl;

public class BackProcessHandler {
    public static boolean onBack(@NonNull AbstractWebViewWrapperCommUIDelegate wrapperDelegate, AbstractWebViewDelegate.ILifeCycleListener lifeCycleListener) {
        wrapperDelegate.hideSoftInput();
        FragmentActivity activity = wrapperDelegate.getActivity();
        if (ViewUtil.activityIsLiving((Activity)activity)) {
            WebViewDelegateImpl webDelegate = wrapperDelegate.getWebDelegate();
            WebView webView = null;
            try {
                webView = webDelegate.getWebView();
            }
            catch (Exception e) {
                LoggerProxy.e(e, "\u83b7\u53d6webview\u51fa\u9519");
                return false;
            }
            if (webView == null || wrapperDelegate.ismWebViewIsDestroy()) {
                return false;
            }
            if (wrapperDelegate.isWebViewIsLoading()) {
                WebView finalWebView = webView;
                ViewPlus.getHandler().postDelayed(() -> {
                    LoggerProxy.d("\u6ca1\u6709\u521d\u59cb\u5316\u7f51\u9875\u5b8c\u6bd5\uff0c\u4f46\u662fwebview\u5df2\u7ecf\u5b9e\u4f8b\u5316\u4e86\uff0c\u76f4\u63a5pop wrapperDelegate");
                    BackProcessHandler._simpleBack(wrapperDelegate, finalWebView);
                }, 500L);
            } else if (wrapperDelegate.isShowErrorLocalPage()) {
                wrapperDelegate.setShowErrorLocalPage(false);
                wrapperDelegate.pop();
            } else {
                boolean lifeCycleListenerHandlerFlag = false;
                if (lifeCycleListener != null) {
                    lifeCycleListenerHandlerFlag = lifeCycleListener.onWebViewDelegateBackPressedSupport();
                }
                if (!lifeCycleListenerHandlerFlag) {
                    AbstractWebViewWrapperCommUIDelegate.ITitleBarEventListener titleBarEventListener = wrapperDelegate.getTitleBarEventListener();
                    boolean isNotidy = false;
                    if (titleBarEventListener != null) {
                        isNotidy = titleBarEventListener.onBackBtnClick();
                    }
                    if (!isNotidy) {
                        BackProcessHandler._simpleBack(wrapperDelegate, webView);
                    }
                } else {
                    LoggerProxy.d("mLifeCycleListener \u5df2\u7ecf\u81ea\u5df1\u5904\u7406\u4e86\u8fd4\u56de\u4e8b\u4ef6");
                }
            }
            return true;
        }
        return false;
    }

    private static void _simpleBack(@NonNull AbstractWebViewWrapperCommUIDelegate wrapperDelegate, @NonNull WebView webView) {
        if (webView.canGoBack()) {
            webView.goBack();
        } else {
            wrapperDelegate.pop();
        }
    }
}

