/*
 * Decompiled with CFR 0.152.
 */
package cn.jiiiiiin.vplus.core.webview.route;

import android.app.Activity;
import android.webkit.URLUtil;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import cn.jiiiiiin.vplus.core.app.ViewPlus;
import cn.jiiiiiin.vplus.core.util.Intent.RouterUtil;
import cn.jiiiiiin.vplus.core.util.log.LoggerProxy;
import cn.jiiiiiin.vplus.core.webview.AbstractWebViewDelegate;
import cn.jiiiiiin.vplus.core.webview.jsbridgehandler.protocol.UriInfo;
import cn.jiiiiiin.vplus.core.webview.loader.IPageLoadListener;
import com.blankj.utilcode.util.ToastUtils;
import java.util.Map;

public class Router {
    static final String ASSET_BASE = "file:///android_asset/";
    static final String RESOURCE_BASE = "file:///android_res/";
    static final String FILE_BASE = "file://";
    static final String PROXY_BASE = "file:///cookieless_proxy/";
    static final String CONTENT_BASE = "content:";
    private static final String AND = "&";
    static final String PROTOCOL_BS = "bs";
    static final String PROTOCOL_TEL = "tel";
    static final String PROTOCOL_HTTP = "http";
    static final String PROTOCOL_HTTPS = "https";

    private Router() {
    }

    public static Router getInstance() {
        return Holder.INSTANCE;
    }

    public final boolean handleWebViewUrlReq(AbstractWebViewDelegate delegate, WebView webView, String url, IPageLoadListener pageLoadListener) {
        boolean res;
        String scheme;
        UriInfo uriInfo = new UriInfo(url);
        if (ViewPlus.IS_DEBUG()) {
            LoggerProxy.e("handleWebViewUrlReq %s %s", url, uriInfo);
        }
        switch (scheme = uriInfo.getScheme()) {
            case "bs": {
                ToastUtils.showLong((CharSequence)"\u5c4f\u5e55\u53f3\u5212\u8fd4\u56de\u624b\u673a\u94f6\u884c");
                pageLoadListener.onInterceptorNoSupportProtocol(url);
                res = true;
                break;
            }
            case "tel": {
                RouterUtil.start4ActionDialProtocol((Activity)delegate.getActivity(), url);
                res = true;
                break;
            }
            case "http": 
            case "https": {
                if (pageLoadListener != null) {
                    LoggerProxy.e("\u901a\u77e5webview\u7684\u5305\u88f9\u5bf9\u8c61\uff0c\u9875\u9762\u53d1\u751f\u4e86onShouldOverrideUrlLoading [%s]", url);
                    res = pageLoadListener.onShouldOverrideUrlLoading(url);
                    break;
                }
                LoggerProxy.e("pageLoadListener\u6ca1\u6709\u8bbe\u7f6e\uff0c\u8ba9\u7cfb\u7edf\u81ea\u5df1\u5904\u7406 %s", url);
                webView.loadUrl(url);
                res = true;
                break;
            }
            default: {
                res = false;
            }
        }
        return res;
    }

    private void loadWebPage(@NonNull WebView webView, @NonNull String url, Map<String, String> additionalHttpHeaders) {
        if (null != additionalHttpHeaders && !additionalHttpHeaders.isEmpty()) {
            webView.loadUrl(url, additionalHttpHeaders);
        } else {
            webView.loadUrl(url);
        }
    }

    public void loadLocalPage(@NonNull WebView webView, @NonNull String url, Map<String, String> additionalHttpHeaders) {
        this.loadWebPage(webView, ASSET_BASE + url, additionalHttpHeaders);
    }

    private void loadPage(@NonNull WebView webView, @NonNull String url, Map<String, String> additionalHttpHeaders) {
        if (URLUtil.isNetworkUrl((String)url) || URLUtil.isAssetUrl((String)url)) {
            this.loadWebPage(webView, url, additionalHttpHeaders);
        } else {
            this.loadLocalPage(webView, url, additionalHttpHeaders);
        }
    }

    public final void loadPage(@NonNull WebView webView, String url, Map<String, String> additionalHttpHeaders, Map<String, String> commParams) {
        if (ViewPlus.IS_DEBUG()) {
            LoggerProxy.d("\u51c6\u5907\u52a0\u8f7dh5: %s \n\u8bf7\u6c42\u5934:%s \n\u901a\u7528\u53c2\u6570:%s", url, additionalHttpHeaders, commParams);
        }
        if (commParams != null && !commParams.isEmpty()) {
            url = url + Router.updateCommParams(commParams, url.indexOf("?") != -1);
        }
        this.loadPage(webView, url, additionalHttpHeaders);
    }

    private static String updateCommParams(Map<String, String> params, boolean hasUrlParams) {
        StringBuffer res = hasUrlParams ? new StringBuffer(AND) : new StringBuffer("?");
        for (Map.Entry<String, String> entry : params.entrySet()) {
            res.append(entry.getKey()).append("=").append(entry.getValue()).append(AND);
        }
        return res.substring(0, res.lastIndexOf(AND));
    }

    private static class Holder {
        private static final Router INSTANCE = new Router();

        private Holder() {
        }
    }
}

