/*
 * Decompiled with CFR 0.152.
 */
package cn.jiiiiiin.vplus.core.webview.jsbridgehandler.protocol;

import android.net.Uri;
import android.text.TextUtils;
import cn.jiiiiiin.vplus.core.util.log.LoggerProxy;
import cn.jiiiiiin.vplus.core.webview.event.model.EventParams;

public class UriInfo {
    private String scheme;
    private String host;
    private String authority;
    private EventParams eventParams;

    public UriInfo(String url) {
        Uri uri = Uri.parse((String)url);
        String scheme = uri.getScheme();
        String host = Uri.parse((String)url).getHost();
        String authority = uri.getAuthority();
        this.scheme = scheme;
        this.host = host;
        this.authority = authority;
        try {
            String params = uri.getQueryParameter("command");
            if (!TextUtils.isEmpty((CharSequence)params)) {
                this.eventParams = EventParams.newInstance(params);
            }
        }
        catch (Exception e) {
            LoggerProxy.e(e, "\u89e3\u6790 url\u5b57\u7b26\u4e32\u6784\u5efaUriInfo\u51fa\u9519 \u3010%s\u3011", url);
        }
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public String getAuthority() {
        return this.authority;
    }

    public EventParams getEventParams() {
        return this.eventParams;
    }

    public String toString() {
        return "UriInfo{scheme='" + this.scheme + '\'' + ", host='" + this.host + '\'' + ", authority='" + this.authority + '\'' + ", eventParams=" + this.eventParams + '}';
    }
}

