/*
 * Decompiled with CFR 0.152.
 */
package cn.jiiiiiin.vplus.core.webview.jsbridgehandler.context;

import android.webkit.JavascriptInterface;
import androidx.annotation.NonNull;
import cn.jiiiiiin.vplus.core.app.ViewPlus;
import cn.jiiiiiin.vplus.core.exception.ViewPlusRuntimeException;
import cn.jiiiiiin.vplus.core.util.log.LoggerProxy;
import cn.jiiiiiin.vplus.core.webview.AbstractWebViewDelegate;
import cn.jiiiiiin.vplus.core.webview.event.model.EventParams;
import cn.jiiiiiin.vplus.core.webview.event.model.EventResData;
import cn.jiiiiiin.vplus.core.webview.jsbridgehandler.JsBridgeCommHandler;
import cn.jiiiiiin.vplus.core.webview.jsbridgehandler.exception.JSBridgeException;
import com.blankj.utilcode.util.StringUtils;

public final class ViewPlusContextWebInterface {
    private final AbstractWebViewDelegate DELEGATE;
    private final IJsBridgeHandler JSBRIDGE_RES_HANDLER;

    private ViewPlusContextWebInterface(AbstractWebViewDelegate delegate, IJsBridgeHandler jsBridgeResHandler) {
        this.DELEGATE = delegate;
        this.JSBRIDGE_RES_HANDLER = jsBridgeResHandler;
    }

    public static ViewPlusContextWebInterface newInstance(@NonNull AbstractWebViewDelegate delegate, @NonNull IJsBridgeHandler jsBridgeResHandler) {
        return new ViewPlusContextWebInterface(delegate, jsBridgeResHandler);
    }

    @JavascriptInterface
    public String event(String params) {
        String res;
        if (ViewPlus.IS_DEBUG()) {
            LoggerProxy.i("\u5ba2\u6237\u7aef\u6536\u5230js[context]\u8c03\u7528\u6d88\u606f -> %s %s", params, this.DELEGATE != null ? this.DELEGATE.getTopDelegate() : "DELEGATE \u4e3anull\uff01\uff01\uff01\uff01");
        }
        String event = "";
        String action = "";
        EventParams eventParams = null;
        try {
            eventParams = EventParams.newInstance(params);
            String appRes = this.JSBRIDGE_RES_HANDLER.onJsCallInterceptor(eventParams);
            if (StringUtils.isEmpty((CharSequence)appRes)) {
                event = eventParams.getEvent();
                action = eventParams.getAction();
                EventResData eventResData = JsBridgeCommHandler.handleJsCall(this.DELEGATE, eventParams, this.DELEGATE.getEventManager());
                res = this.JSBRIDGE_RES_HANDLER.onRespH5(eventResData, eventParams);
            } else {
                res = appRes;
            }
        }
        catch (JSBridgeException e) {
            LoggerProxy.e(e, "\u8c03\u7528\u6865\u63a5Event\u51fa\u9519JSBridgeException");
            res = this.JSBRIDGE_RES_HANDLER.onRespH5(EventResData.error(e.getCode(), e.getMessage()), eventParams);
        }
        catch (ViewPlusRuntimeException e) {
            String errCode;
            switch (errCode = e.getCode()) {
                case "get_webview_return_null_must_stop_jsbridge": {
                    res = this.JSBRIDGE_RES_HANDLER.onRespH5(EventResData.success(), eventParams);
                    break;
                }
                default: {
                    res = this.JSBRIDGE_RES_HANDLER.onRespH5(EventResData.error(e.getCode(), e.getMessage()), eventParams);
                    break;
                }
            }
        }
        catch (Exception e) {
            LoggerProxy.e(e, "\u6865\u63a5\u8c03\u7528\u51fa\u73b0\u610f\u6599\u4e4b\u5916\u7684\u9519\u8bef\uff01");
            res = this.JSBRIDGE_RES_HANDLER.onRespH5(EventResData.error("def_un_catch_error", String.format("\u5904\u7406\u672c\u6b21\u8bf7\u6c42\u51fa\u73b0\u9519\u8bef[%s]", e.getMessage())), eventParams);
        }
        if (ViewPlus.IS_DEBUG()) {
            LoggerProxy.i("\u5ba2\u6237\u7aef\u8fd4\u56dejs[context]\u5904\u7406\u6d88\u606f -> %s return: %s", event + "-" + action, res);
        }
        return res;
    }

    public static interface IJsBridgeHandler {
        public String onJsCallInterceptor(EventParams var1) throws JSBridgeException;

        public String onRespH5(EventResData var1, EventParams var2);
    }
}

