/*
 * Decompiled with CFR 0.152.
 */
package cn.jiiiiiin.vplus.core.webview.jsbridgehandler;

import android.os.Handler;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import cn.jiiiiiin.vplus.core.app.ViewPlus;
import cn.jiiiiiin.vplus.core.exception.ViewPlusException;
import cn.jiiiiiin.vplus.core.exception.ViewPlusRuntimeException;
import cn.jiiiiiin.vplus.core.util.log.LoggerProxy;
import cn.jiiiiiin.vplus.core.webview.AbstractWebViewDelegate;
import cn.jiiiiiin.vplus.core.webview.event.AbstractEvent;
import cn.jiiiiiin.vplus.core.webview.event.IEventManager;
import cn.jiiiiiin.vplus.core.webview.event.model.EventParams;
import cn.jiiiiiin.vplus.core.webview.event.model.EventResData;
import cn.jiiiiiin.vplus.core.webview.jsbridgehandler.exception.JSBridgeException;
import com.blankj.utilcode.util.StringUtils;
import com.blankj.utilcode.util.ToastUtils;

public final class JsBridgeCommHandler {
    protected static final Handler HANDLER = ViewPlus.getHandler();

    public static EventResData handleJsCall(AbstractWebViewDelegate webDelegate, EventParams eventParams, IEventManager eventManager) throws JSBridgeException {
        if (eventParams == null) {
            throw new JSBridgeException("\u4ea4\u4e92\u4e8b\u4ef6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", "event_params_is_null");
        }
        String eventKey = eventParams.getEvent();
        AbstractEvent event = eventManager.createEvent(eventKey);
        if (event != null) {
            event.setEventParams(eventParams);
            event.setDelegate(webDelegate);
            try {
                event.setUrl(webDelegate.getUrl());
            }
            catch (ViewPlusException e) {
                LoggerProxy.e(e, "event.setUrl(webDelegate.getUrl()); err");
            }
            event.setEventManager(eventManager);
            EventResData eventResData = event.execute(eventParams);
            if (eventResData == null) {
                throw new JSBridgeException(String.format("[%s]\u4e8b\u4ef6\u5904\u7406\u51fd\u6570\u6ca1\u6709\u8fd4\u56de\u5904\u7406\u7ed3\u679c", eventKey), "event_not_resp_code_on_handlejscall");
            }
            return eventResData;
        }
        throw new JSBridgeException(String.format("\u4e8b\u4ef6\u7ba1\u7406\u5668\u4e2d\u672a\u6ce8\u518c[%s]\u4e8b\u4ef6\u7ec4", eventKey), "event_undfound_in_eventmanager_on_handlejscall");
    }

    public static void callJs(WebView webView, String funcName) {
        JsBridgeCommHandler.callJs(webView, funcName, "", null);
    }

    public static void callJs(WebView webView, String funcName, String params) {
        JsBridgeCommHandler.callJs(webView, funcName, params, null);
    }

    public static void callJs(WebView webView, String funcName, String params, ValueCallback<String> resultCallback) {
        if (StringUtils.isTrimEmpty((String)funcName)) {
            LoggerProxy.e("callJs\u8c03\u7528\u8b66\u544a\uff0c\u5f85\u8c03\u7528\u7684\u524d\u7aef\u51fd\u6570\u540d\u4e3a\u7a7a");
            if (ViewPlus.IS_DEBUG()) {
                throw new ViewPlusRuntimeException("callJs funcName is empty");
            }
            ToastUtils.showLong((CharSequence)"\u51fa\u9519\u4e86[\u8c03\u7528\u524d\u7aef\u7684\u65b9\u6cd5\u540d\u4e3a\u7a7a]");
        } else if (webView == null) {
            LoggerProxy.e("callJs\u8c03\u7528\u8b66\u544a\uff0cwebView\u4e3anull\uff0cfuncName: %s params: %s \n\u8fd9\u79cd\u60c5\u51b5\u53ea\u51fa\u73b0\u5728\u5f53\u524d\u7684webview delegate\u88ab\u9500\u6bc1\uff0c\u90a3\u4e48\u662f\u4e0d\u9700\u8981\u518d\u6267\u884c\u5176\u6ce8\u518c\u7684\u4e00\u4e9b\u76d1\u542c\u51fd\u6570", funcName, params);
        } else {
            if (ViewPlus.IS_DEBUG()) {
                LoggerProxy.d("\u8c03\u7528\u7f51\u9875\u4e2d\u7684js -> funcName: %s , params: %s", funcName, params);
            }
            try {
                HANDLER.post(() -> webView.evaluateJavascript(funcName + "('" + params + "');", resultCallback));
            }
            catch (Exception e) {
                LoggerProxy.e(e, "webView.evaluateJavascript \u51fa\u73b0\u9519\u8bef");
            }
        }
    }
}

