/*
 * Decompiled with CFR 0.152.
 */
package cn.jiiiiiin.vplus.core.webview.event.model;

import androidx.annotation.NonNull;
import cn.jiiiiiin.vplus.core.app.ConfigKeys;
import cn.jiiiiiin.vplus.core.app.ViewPlus;
import cn.jiiiiiin.vplus.core.exception.ViewPlusRuntimeException;
import com.alibaba.fastjson.JSONObject;
import com.blankj.utilcode.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class EventResData {
    private String code;
    private String msg;
    private Map<String, Object> dataMap;

    public EventResData putData(@NonNull String key, Object val) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            throw new ViewPlusRuntimeException("putdata_key_is_err", "\u8bbe\u7f6e\u8fd4\u56de\u5185\u5bb9\u7684\u952e\u4e3a\u7a7a\u9519\u8bef");
        }
        if (val == null) {
            throw new ViewPlusRuntimeException("putdata_val_is_err", "\u8bbe\u7f6e\u8fd4\u56de\u5185\u5bb9\u7684\u503c\u4e3a\u7a7a\u9519\u8bef");
        }
        if (this.dataMap == null) {
            this.dataMap = new HashMap<String, Object>();
        }
        this.dataMap.put(key, val);
        return this;
    }

    public EventResData() {
    }

    public EventResData(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public String getCode() {
        return this.code;
    }

    public EventResData setCode(String code) {
        this.code = code;
        return this;
    }

    public String getMsg() {
        return this.msg;
    }

    public EventResData setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public Map<String, Object> getDataMap() {
        return this.dataMap;
    }

    public void setDataMap(Map<String, Object> dataMap) {
        this.dataMap = dataMap;
    }

    public String toJson() {
        JSONObject jsonObject = new JSONObject();
        if (this.dataMap != null && !this.dataMap.isEmpty()) {
            jsonObject.putAll(this.dataMap);
        }
        jsonObject.put((String)ViewPlus.getConfiguration((Object)ConfigKeys.SERVER_STATUS_CODE_KEY), (Object)this.code);
        jsonObject.put((String)ViewPlus.getConfiguration((Object)ConfigKeys.SERVER_STATUS_MSG_KEY), (Object)this.msg);
        return jsonObject.toJSONString();
    }

    public static EventResData success() {
        return new EventResData((String)ViewPlus.getConfiguration((Object)ConfigKeys.SERVER_STATUS_CODE_SUCCESS_FLAG), "\u8bf7\u6c42\u6210\u529f");
    }

    public static EventResData error(String code, String msg) {
        EventResData error = new EventResData();
        return error.setCode(code).setMsg(msg);
    }

    public EventResData putData(Map<String, Object> data) {
        if (this.dataMap == null) {
            this.dataMap = new HashMap<String, Object>();
        }
        this.dataMap.putAll(data);
        return this;
    }

    public EventResData putData2(Map<String, String> args) {
        if (this.dataMap == null) {
            this.dataMap = new HashMap<String, Object>();
        }
        Set<Map.Entry<String, String>> entrySet = args.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            this.dataMap.put(entry.getKey(), entry.getValue());
        }
        return this;
    }
}

