/*
 * Decompiled with CFR 0.152.
 */
package cn.jiiiiiin.vplus.core.webview.client;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.text.TextUtils;
import android.webkit.ClientCertRequest;
import android.webkit.HttpAuthHandler;
import android.webkit.SslErrorHandler;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import cn.jiiiiiin.vplus.core.util.log.LoggerProxy;
import cn.jiiiiiin.vplus.core.webview.AbstractWebViewDelegate;
import cn.jiiiiiin.vplus.core.webview.loader.IPageLoadListener;
import cn.jiiiiiin.vplus.core.webview.route.Router;

public class WebViewClientImpl
extends WebViewClient {
    private final AbstractWebViewDelegate DELEGATE;
    private IPageLoadListener mIPageLoadListener = null;
    private long mStart = 0L;
    private boolean mIgnoreWhiteURL = false;

    public WebViewClientImpl(AbstractWebViewDelegate delegate, IPageLoadListener listener, boolean isIgnoreWhiteURL) {
        this.DELEGATE = delegate;
        this.mIPageLoadListener = listener;
        this.mIgnoreWhiteURL = isIgnoreWhiteURL;
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
        this.mStart = System.currentTimeMillis();
        if (this.mIPageLoadListener != null) {
            this.mIPageLoadListener.onLoadStart(view);
        }
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        LoggerProxy.w("===shouldOverrideUrlLoading %s", url);
        if (!this.mIgnoreWhiteURL) {
            return Router.getInstance().handleWebViewUrlReq(this.DELEGATE, view, url, this.mIPageLoadListener);
        }
        return false;
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        if (this.mIPageLoadListener != null) {
            LoggerProxy.i("===h5\u9875\u9762[%s]\u52a0\u8f7d\u5b8c\u6bd5 onPageFinished \u82b1\u8d39\uff1a %s", url, System.currentTimeMillis() - this.mStart);
            this.mIPageLoadListener.onLoadEnd(false);
        }
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        super.onReceivedError(view, errorCode, description, failingUrl);
        LoggerProxy.d("onReceivedError %s %s", errorCode, failingUrl);
        if (!this._isUnHandler(view, errorCode, failingUrl) && !TextUtils.isEmpty((CharSequence)failingUrl) && failingUrl.equals(view.getUrl()) && this.mIPageLoadListener != null && this.mIPageLoadListener.isHandlerOnReceivedErrorRes(Uri.parse((String)failingUrl))) {
            LoggerProxy.e("onReceivedError handler %s %s", errorCode, failingUrl);
            this.mIPageLoadListener.onReceivedError(view, errorCode, description, failingUrl);
        }
    }

    private boolean _isUnHandler(WebView view, int errorCode, String failingUrl) {
        return failingUrl != null && !failingUrl.equals(view.getUrl()) && !failingUrl.equals(view.getOriginalUrl()) || failingUrl == null && errorCode != -12 || errorCode == -1;
    }

    public void onReceivedHttpAuthRequest(WebView view, HttpAuthHandler handler, String host, String realm) {
        handler.cancel();
    }

    public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
        handler.proceed();
    }

    @TargetApi(value=21)
    public void onReceivedClientCertRequest(WebView view, ClientCertRequest request) {
        request.cancel();
    }
}

