/*
 * Decompiled with CFR 0.152.
 */
package cn.jiiiiiin.vplus.core.webview.chromeclient;

import android.app.Activity;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.webkit.ConsoleMessage;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import cn.jiiiiiin.vplus.core.app.ViewPlus;
import cn.jiiiiiin.vplus.core.ui.dialog.DialogUtil;
import cn.jiiiiiin.vplus.core.util.log.LoggerProxy;
import cn.jiiiiiin.vplus.core.webview.IWebViewConsoleMessage;
import cn.jiiiiiin.vplus.core.webview.loader.IPageLoadListener;
import com.afollestad.materialdialogs.MaterialDialog;
import com.luck.picture.lib.PictureSelector;
import com.luck.picture.lib.config.PictureMimeType;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;

public class WebChromeClientImpl
extends WebChromeClient {
    private static final int WEBVIEW_PROGRESS_OK = 80;
    private final Activity mActivity;
    private IPageLoadListener mPageLoadListener;
    private boolean mIsNotifyOnprogresschangedI00 = false;
    public static ValueCallback<Uri> uploadMessage;
    public static ValueCallback<Uri[]> uploadMessageAboveL;
    private IWebViewConsoleMessage mWebViewConsoleMessage;

    public WebChromeClientImpl(Activity activity, IPageLoadListener pageLoadListener, IWebViewConsoleMessage webViewConsoleMessage) {
        this.mActivity = activity;
        this.mPageLoadListener = pageLoadListener;
        this.mWebViewConsoleMessage = webViewConsoleMessage;
    }

    public void onProgressChanged(WebView view, int newProgress) {
        super.onProgressChanged(view, newProgress);
        if (newProgress < 80) {
            this.mIsNotifyOnprogresschangedI00 = false;
        }
        if (this.mPageLoadListener != null && !this.mIsNotifyOnprogresschangedI00) {
            this.mIsNotifyOnprogresschangedI00 = newProgress >= 80;
            this.mPageLoadListener.onProgressChanged(view, newProgress);
            if (this.mIsNotifyOnprogresschangedI00) {
                if (!view.getSettings().getLoadsImagesAutomatically()) {
                    view.getSettings().setLoadsImagesAutomatically(true);
                }
                LoggerProxy.i("===h5\u9875\u9762[%s]\u52a0\u8f7d\u5b8c\u6bd5 onProgressChanged", newProgress);
                this.mPageLoadListener.onLoadEnd(true);
            }
        }
    }

    public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
        DialogUtil.dialog(this.mActivity, "\u63d0\u793a", message, dialog -> result.confirm());
        return true;
    }

    public boolean onJsConfirm(WebView view, String url, String message, JsResult result) {
        DialogUtil.confirmDialog(this.mActivity, message, (Function1<? super MaterialDialog, Unit>)((Function1)positive -> {
            result.confirm();
            return Unit.INSTANCE;
        }), (Function1<? super MaterialDialog, Unit>)((Function1)negative -> {
            result.cancel();
            return Unit.INSTANCE;
        }));
        return true;
    }

    public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, JsPromptResult result) {
        DialogUtil.promptDialog(this.mActivity, message, "", defaultValue, (Function2<? super MaterialDialog, CharSequence, Unit>)((Function2)(dialog, input) -> {
            result.confirm(String.valueOf(input));
            dialog.dismiss();
            return Unit.INSTANCE;
        }));
        return true;
    }

    public void onReceivedTitle(WebView view, String title) {
        super.onReceivedTitle(view, title);
        if (Build.VERSION.SDK_INT < 23 && !TextUtils.isEmpty((CharSequence)title)) {
            if (title.contains("404") || title.contains("\u627e\u4e0d\u5230\u7f51\u9875") || title.contains("\u7f51\u9875\u65e0\u6cd5\u6253\u5f00")) {
                LoggerProxy.e("TTTTT \u5f85\u8c03\u8bd5\u60c5\u51b5\u51fa\u73b0 %s %s", view.getUrl(), view.getOriginalUrl());
                this.mPageLoadListener.onReceivedError(view, 404, "404", view.getUrl());
            } else if (title.contains("500") || title.contains("Error")) {
                LoggerProxy.e("TTTTT \u5f85\u8c03\u8bd5\u60c5\u51b5\u51fa\u73b0 %s %s", view.getUrl(), view.getOriginalUrl());
                this.mPageLoadListener.onReceivedError(view, 500, "404", view.getUrl());
            }
        }
    }

    public void openFileChooser(ValueCallback<Uri> valueCallback) {
        uploadMessage = valueCallback;
        this.openImageChooserActivity();
    }

    public void openFileChooser(ValueCallback valueCallback, String acceptType) {
        uploadMessage = valueCallback;
        this.openImageChooserActivity();
    }

    public void openFileChooser(ValueCallback<Uri> valueCallback, String acceptType, String capture) {
        uploadMessage = valueCallback;
        this.openImageChooserActivity();
    }

    public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, WebChromeClient.FileChooserParams fileChooserParams) {
        uploadMessageAboveL = filePathCallback;
        this.openImageChooserActivity();
        return true;
    }

    private void openImageChooserActivity() {
        ViewPlus.getConfigurator().withStartOtherActivity(true);
        PictureSelector.create((Activity)this.mActivity).openGallery(PictureMimeType.ofImage()).selectionMode(2).maxSelectNum(1).minSelectNum(1).imageSpanCount(4).selectionMode(2).previewImage(true).isCamera(true).isGif(false).compress(true).synOrAsy(false).forResult(188);
    }

    public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
        if (ViewPlus.IS_DEBUG()) {
            LoggerProxy.w("\u524d\u7aefconsole\u4fe1\u606f %s %s %s", consoleMessage.message(), consoleMessage.lineNumber(), consoleMessage.sourceId());
        }
        if (null != this.mWebViewConsoleMessage) {
            this.mWebViewConsoleMessage.onConsoleMessage(consoleMessage);
        }
        return super.onConsoleMessage(consoleMessage);
    }
}

