/*
 * Decompiled with CFR 0.152.
 */
package cn.jiiiiiin.vplus.core.webview;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.os.Build;
import android.webkit.CookieManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import cn.jiiiiiin.vplus.core.app.ConfigKeys;
import cn.jiiiiiin.vplus.core.app.ViewPlus;
import cn.jiiiiiin.vplus.core.util.log.LoggerProxy;
import cn.jiiiiiin.vplus.core.util.network.HttpAdjectiveUtil;
import com.blankj.utilcode.util.ToastUtils;

class WebViewInitializer {
    private static final String LOAD_CACHE_ELSE_NETWORK_TOAST_MSG = "\u8bf7\u68c0\u67e5\u5f53\u524d\u7f51\u7edc\u73af\u5883\u662f\u5426\u6d41\u7545";

    WebViewInitializer() {
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    static WebView createWebView(WebView webView) {
        if (ViewPlus.IS_DEBUG() && Build.VERSION.SDK_INT >= 19) {
            WebView.setWebContentsDebuggingEnabled((boolean)true);
        }
        CookieManager cookieManager = CookieManager.getInstance();
        cookieManager.setAcceptCookie(true);
        if (Build.VERSION.SDK_INT >= 21) {
            cookieManager.setAcceptThirdPartyCookies(webView, false);
        }
        CookieManager.setAcceptFileSchemeCookies((boolean)false);
        webView.setScrollBarStyle(0x2000000);
        webView.setHorizontalScrollBarEnabled(false);
        webView.setVerticalScrollBarEnabled(false);
        webView.setDrawingCacheEnabled(ViewPlus.IS_DEBUG());
        WebSettings settings = webView.getSettings();
        if (settings == null) {
            return webView;
        }
        settings.setDefaultTextEncodingName("utf-8");
        settings.setJavaScriptEnabled(true);
        String useragent = settings.getUserAgentString().concat(";").concat((String)ViewPlus.getConfiguration((Object)ConfigKeys.WEB_USER_AGENT));
        settings.setUserAgentString(useragent);
        if (Build.VERSION.SDK_INT >= 21) {
            settings.setMixedContentMode(0);
        }
        if (Build.VERSION.SDK_INT >= 23) {
            settings.setOffscreenPreRaster(false);
        }
        settings.setAllowContentAccess(false);
        settings.setAllowFileAccess(false);
        settings.setAllowFileAccessFromFileURLs(false);
        settings.setAllowUniversalAccessFromFileURLs(false);
        if (Build.VERSION.SDK_INT >= 19) {
            webView.getSettings().setLoadsImagesAutomatically(true);
        } else {
            webView.getSettings().setLoadsImagesAutomatically(false);
        }
        if (Build.VERSION.SDK_INT < 18) {
            settings.setAppCacheMaxSize(0xA00000L);
        }
        settings.setAppCacheEnabled(true);
        settings.setDatabaseEnabled(false);
        settings.setDomStorageEnabled(true);
        if (HttpAdjectiveUtil.canAccess2NewWork()) {
            settings.setCacheMode(-1);
        } else {
            settings.setCacheMode(1);
            ToastUtils.showLong((CharSequence)LOAD_CACHE_ELSE_NETWORK_TOAST_MSG);
        }
        settings.setSavePassword(false);
        settings.setSaveFormData(true);
        settings.setNeedInitialFocus(true);
        settings.setUseWideViewPort(true);
        settings.setLoadWithOverviewMode(true);
        settings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
        settings.setSupportMultipleWindows(false);
        settings.setJavaScriptCanOpenWindowsAutomatically(false);
        settings.setDefaultTextEncodingName("UTF-8");
        settings.setBuiltInZoomControls(false);
        settings.setDisplayZoomControls(false);
        settings.setSupportZoom(false);
        settings.setTextZoom(100);
        WebViewInitializer.removeJavascriptInterfaces(webView);
        return webView;
    }

    @TargetApi(value=11)
    private static void removeJavascriptInterfaces(WebView webView) {
        try {
            if (Build.VERSION.SDK_INT >= 11 && Build.VERSION.SDK_INT < 17) {
                webView.removeJavascriptInterface("searchBoxJavaBridge_");
                webView.removeJavascriptInterface("accessibility");
                webView.removeJavascriptInterface("accessibilityTraversal");
            }
        }
        catch (Throwable tr) {
            LoggerProxy.e(tr, "\u6e05\u7406\u79c1\u6709\u7684\u6865\u63a5\u51fa\u9519");
        }
    }
}

