/*
 * Decompiled with CFR 0.152.
 */
package cn.jiiiiiin.vplus.core.webview;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import cn.jiiiiiin.vplus.core.app.ConfigKeys;
import cn.jiiiiiin.vplus.core.app.ViewPlus;
import cn.jiiiiiin.vplus.core.delegates.BaseDelegate;
import cn.jiiiiiin.vplus.core.exception.ViewPlusException;
import cn.jiiiiiin.vplus.core.exception.ViewPlusRuntimeException;
import cn.jiiiiiin.vplus.core.util.log.LoggerProxy;
import cn.jiiiiiin.vplus.core.webview.AbstractWebViewDelegate;
import cn.jiiiiiin.vplus.core.webview.IWebViewInitializer;
import cn.jiiiiiin.vplus.core.webview.WebViewInitializer;
import cn.jiiiiiin.vplus.core.webview.WebViewLongClickHandlerDelegate;
import cn.jiiiiiin.vplus.core.webview.chromeclient.WebChromeClientImpl;
import cn.jiiiiiin.vplus.core.webview.client.WebViewClientImpl;
import cn.jiiiiiin.vplus.core.webview.loader.IPageLoadListener;
import cn.jiiiiiin.vplus.core.webview.route.RouteKeys;
import cn.jiiiiiin.vplus.core.webview.route.Router;
import cn.jiiiiiin.vplus.core.webview.util.WebViewUtil;

public class WebViewDelegateImpl
extends WebViewLongClickHandlerDelegate {
    private IPageLoadListener mIPageLoadListener = null;
    private boolean isSyncCookied = false;

    public boolean isSyncCookied() {
        return this.isSyncCookied;
    }

    public void setSyncCookied(boolean syncCookied) {
        this.isSyncCookied = syncCookied;
    }

    public static WebViewDelegateImpl newInstance(String url, boolean isUseCacheWebViewImpl, boolean needSwipeBack, boolean needSyncCookie) {
        Bundle args = new Bundle();
        args.putString(RouteKeys.URL.name(), url);
        args.putBoolean(RouteKeys.IS_USE_CACHE_WEB_VIEW_IMPL.name(), isUseCacheWebViewImpl);
        args.putBoolean(RouteKeys.NEED_SWIPE_BACK.name(), needSwipeBack);
        args.putBoolean(RouteKeys.NEED_SYNC_COOKIE.name(), needSyncCookie);
        WebViewDelegateImpl delegate = new WebViewDelegateImpl();
        delegate.setArguments(args);
        return delegate;
    }

    @Override
    protected boolean isImmersionBarEnabled() {
        return false;
    }

    @Override
    public Object setLayout() {
        try {
            return this.getWebView();
        }
        catch (ViewPlusException e) {
            LoggerProxy.e("setLayout getWebView ERR");
            return null;
        }
    }

    public AbstractWebViewDelegate setPageLoadListener(IPageLoadListener listener) {
        this.mIPageLoadListener = listener;
        return this;
    }

    @Override
    public void onBindView(@Nullable Bundle savedInstanceState, @NonNull View rootView) {
        super.onBindView(savedInstanceState, rootView);
        String url = null;
        try {
            url = this.getUrl();
        }
        catch (ViewPlusException e) {
            LoggerProxy.e(e, "onBindView getUrl err");
        }
        if (this.mNeedSyncCookie) {
            try {
                String cookie = (String)ViewPlus.getConfiguration((Object)ConfigKeys.SESSION_ID);
                if (ViewPlus.IS_DEBUG()) {
                    LoggerProxy.w("webview \u7684delegate \u540c\u6b65\u5168\u5c40\u914d\u7f6e\u4e2d\u7684cookie %s", cookie);
                }
                if (cookie != null && url != null) {
                    this.isSyncCookied = WebViewUtil.syncCookie(url, cookie);
                }
            }
            catch (ViewPlusRuntimeException e) {
                this.isSyncCookied = false;
                LoggerProxy.e("\u540c\u6b65 sync Cookie err %s", e.getMessage());
            }
        }
        if (ViewPlus.IS_DEBUG()) {
            LoggerProxy.d("\u52a0\u8f7d\u9875\u9762 %s %s %s", url, this.mHeaderParams, this.mUrlParams);
        }
        ViewPlus.getConfigurator().withWebViewCurrentLoadUrl(url);
        Router.getInstance().loadPage(this.mWebView, url, this.mHeaderParams, this.mUrlParams);
    }

    @Override
    public IWebViewInitializer setInitializer() {
        return this;
    }

    @Override
    public WebView initWebView(WebView webView) {
        return WebViewInitializer.createWebView(webView);
    }

    @Override
    public WebViewClient initWebViewClient() {
        return new WebViewClientImpl(this, this.mIPageLoadListener, this.mIgnoreWhiteURL);
    }

    @Override
    public WebChromeClient initWebChromeClient() {
        return new WebChromeClientImpl((Activity)this._mActivity, this.mIPageLoadListener, this.mWebViewConsoleMessage);
    }

    @Override
    protected Class<? extends BaseDelegate> getRootClazz() {
        return null;
    }
}

