/*
 * Decompiled with CFR 0.152.
 */
package cn.jiiiiiin.vplus.core.webview;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import butterknife.BindView;
import butterknife.OnClick;
import cn.jiiiiiin.vplus.core.R;
import cn.jiiiiiin.vplus.core.app.ConfigKeys;
import cn.jiiiiiin.vplus.core.app.ViewPlus;
import cn.jiiiiiin.vplus.core.util.log.LoggerProxy;
import cn.jiiiiiin.vplus.core.util.ui.ViewUtil;
import cn.jiiiiiin.vplus.core.webview.AbstractWebViewInteractiveDelegate;
import cn.jiiiiiin.vplus.core.webview.util.BackProcessHandler;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.blankj.utilcode.util.KeyboardUtils;
import com.blankj.utilcode.util.StringUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.bumptech.glide.Glide;
import com.scwang.smartrefresh.header.MaterialHeader;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.ScrollBoundaryDecider;
import com.wuhenzhizao.titlebar.widget.CommonTitleBar;
import java.util.Objects;
import me.yokeyword.fragmentation.anim.DefaultHorizontalAnimator;
import me.yokeyword.fragmentation.anim.FragmentAnimator;
import me.zhanghai.android.materialprogressbar.MaterialProgressBar;

public abstract class AbstractWebViewWrapperCommUIDelegate
extends AbstractWebViewInteractiveDelegate {
    public static final String ARG_TITLE = "arg_title";
    public static final String ARG_URL = "arg_url";
    private String mInitUrl;
    private String mTitle;
    private ITitleBarEventListener mTitleBarEventListener;
    private MaterialProgressBar progressBar;
    @BindView(value=2150)
    ViewGroup mLLRootContainer;
    @BindView(value=2332)
    CommonTitleBar mCommonTitleBar;
    protected boolean mIsToolbarInitialised = false;
    protected int mTitleBarVisibleVal = 0;
    @BindView(value=2333)
    protected View bottomLine;
    protected TextView centerTextView;
    @BindView(value=2337)
    protected View mToolBarCloseContainer;
    protected int mIsCloseContainerVisibleVal = 8;
    @BindView(value=2336)
    protected View mToolbarBackContainer;
    protected int mIsBackContainerVisibleVal = 0;
    @BindView(value=2099)
    protected ViewGroup mPlaceholderContainer;
    @BindView(value=2356)
    protected TextView mErrTextView;
    @BindView(value=2245)
    protected ViewGroup mErrContainer;
    protected boolean isShowErrorLocalPage = false;
    @BindView(value=2293)
    protected SmartRefreshLayout mSmartRefreshLayout;
    @BindView(value=2102)
    protected ViewGroup mTitleBarRightContainer;
    private static final LinearLayout.LayoutParams TITLE_BAR_RIGHT_TV_LAYOUT_PARAMS = new LinearLayout.LayoutParams(-2, -2);
    private static final LinearLayout.LayoutParams TITLE_BAR_RIGHT_ICON_LAYOUT_PARAMS = new LinearLayout.LayoutParams(45, 45);
    protected int mTitleBarBtnColor = -16776961;
    protected boolean mIgnoreWhiteURL = false;

    @OnClick(value={2336})
    public void onToolBarBackContainerClick() {
        this.onBackPressedSupport();
    }

    @OnClick(value={2337})
    public void onToolBarCloseContainerClick() {
        this.hideSoftInput();
        ViewPlus.getHandler().postDelayed(() -> {
            if (this.mTitleBarEventListener != null) {
                this.mTitleBarEventListener.onCloseBtnClick();
            } else {
                this.popToRoot();
            }
        }, 100L);
    }

    @OnClick(value={2245})
    public void onErrRefreshBtnTap() {
        this.isShowErrorLocalPage = false;
        this.mWebViewDelegate.refresh();
    }

    @Override
    public Object setLayout() {
        return R.layout.delegate_comm_h5_wrapper_layout;
    }

    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Bundle args = this.getArguments();
        if (args != null) {
            this.mInitUrl = this.mURL = args.getString(ARG_URL);
            this.mTitle = args.getString(ARG_TITLE);
        }
        View rootView = super.onCreateView(inflater, container, savedInstanceState);
        assert (rootView != null);
        this.progressBar = (MaterialProgressBar)rootView.findViewById(R.id.progress_bar);
        this._initToolbar();
        this._initSmartRefreshLayout();
        return rootView;
    }

    private void _initSmartRefreshLayout() {
        this.mSmartRefreshLayout.setEnableAutoLoadMore(false);
        this.mSmartRefreshLayout.setEnableOverScrollDrag(false);
        this.mSmartRefreshLayout.setEnableOverScrollBounce(false);
        this.mSmartRefreshLayout.setEnableAutoLoadMore(false);
        MaterialHeader mMaterialHeader = (MaterialHeader)this.mSmartRefreshLayout.getRefreshHeader();
        if (mMaterialHeader != null) {
            mMaterialHeader.setColorSchemeColors(new int[]{(Integer)ViewPlus.getConfiguration((Object)ConfigKeys.APP_THEME_COLOR)});
        }
        this.mSmartRefreshLayout.setScrollBoundaryDecider(new ScrollBoundaryDecider(){

            public boolean canRefresh(View content) {
                try {
                    return AbstractWebViewWrapperCommUIDelegate.this.mWebViewDelegate.getWebViewOrNullllll().getScrollY() <= 0;
                }
                catch (Exception e) {
                    LoggerProxy.e(e, "canRefresh err");
                    return false;
                }
            }

            public boolean canLoadMore(View content) {
                return false;
            }
        });
        this.setPullRefresh(this.canPullRefresh());
    }

    private void _registerSmartRefreshLayoutListener() {
        this.mSmartRefreshLayout.setOnRefreshListener(refreshLayout -> this.safetyUseWebView(webView -> this.mWebViewDelegate.refresh()));
    }

    protected boolean canPullRefresh() {
        return false;
    }

    public AbstractWebViewWrapperCommUIDelegate setPullRefresh(boolean canPullRefresh) {
        this.mSmartRefreshLayout.setEnableRefresh(canPullRefresh);
        if (canPullRefresh) {
            this._registerSmartRefreshLayoutListener();
        }
        return this;
    }

    @Override
    public void onBindView(@Nullable Bundle savedInstanceState, View rootView) {
        super.onBindView(savedInstanceState, rootView);
        this.mPlaceholderContainer.setVisibility(this.isOpenH5PlaceholderPage());
    }

    @Override
    protected View titleBar() {
        return this.mCommonTitleBar;
    }

    protected int isOpenH5PlaceholderPage() {
        return 0;
    }

    public boolean onBackPressedSupport() {
        boolean res = BackProcessHandler.onBack(this, this);
        if (res) {
            ViewPlus.getConfigurator().withWebViewCurrentLoadUrl(null);
        }
        return res;
    }

    protected void _initToolbar() {
        this.mCommonTitleBar.setVisibility(this.mTitleBarVisibleVal);
        this.bottomLine.setVisibility(this.mTitleBarVisibleVal);
        this.centerTextView = this.mCommonTitleBar.getCenterTextView();
        this.centerTextView.setVisibility(0);
        if (!TextUtils.isEmpty((CharSequence)this.mTitle)) {
            this.centerTextView.setText((CharSequence)this.mTitle);
        } else {
            this.centerTextView.setVisibility(8);
        }
        this.mToolbarBackContainer.setVisibility(this.mIsBackContainerVisibleVal);
        this.mToolbarBackContainer.setOnClickListener(v -> this.onBackPressedSupport());
        this.mToolBarCloseContainer.setVisibility(this.mIsCloseContainerVisibleVal);
        this.mIsToolbarInitialised = true;
        this.mTitleBarBtnColor = Build.VERSION.SDK_INT >= 23 ? this.getResources().getColor(R.color.link_color, this._mActivity.getTheme()) : this.getResources().getColor(R.color.link_color);
    }

    public AbstractWebViewWrapperCommUIDelegate setTitleBarVisible(Boolean visible) {
        if (this.mIsToolbarInitialised) {
            ViewUtil.setVisibility((View)this.mCommonTitleBar, visible);
        } else {
            this.mTitleBarVisibleVal = visible != false ? 0 : 8;
        }
        return this;
    }

    public AbstractWebViewWrapperCommUIDelegate setBackBtnVisible(Boolean visible) {
        if (this.mIsToolbarInitialised) {
            ViewUtil.setVisibility2(this.mToolbarBackContainer, visible);
        } else {
            this.mIsBackContainerVisibleVal = visible != false ? 0 : 8;
        }
        return this;
    }

    public AbstractWebViewWrapperCommUIDelegate setCloseBtnVisible(Boolean visible) {
        if (this.mIsToolbarInitialised) {
            ViewUtil.setVisibility2(this.mToolBarCloseContainer, visible);
        } else {
            this.mIsCloseContainerVisibleVal = visible != false ? 0 : 8;
        }
        return this;
    }

    public AbstractWebViewWrapperCommUIDelegate setIgnoreWhiteURL(boolean isIgnoreWhiteURL) {
        this.mIgnoreWhiteURL = isIgnoreWhiteURL;
        return this;
    }

    public void addTitleBarRightMenus(JSONArray finalRightMenusConfig) {
        ViewPlus.getHandler().post(() -> this.safetyUseWebView(webView -> {
            int idx = finalRightMenusConfig.size();
            for (int i = 0; i < idx; ++i) {
                JSONObject menuInfo = finalRightMenusConfig.getJSONObject(i);
                String listener = menuInfo.getString("listener");
                String title = menuInfo.getString("title");
                String iconUrl = menuInfo.getString("icon");
                if (StringUtils.isEmpty((CharSequence)listener)) {
                    LoggerProxy.e("addTitleBarRightMenus\u914d\u7f6e\u6807\u9898\u680f\u53f3\u8fb9\u81ea\u5b9a\u4e49\u83dc\u5355\uff0c\u4f20\u9012\u7684\u53c2\u6570\u9519\u8bef\uff0c\u76d1\u542c\u51fd\u6570\u540d\u5b57\u4e3a\u7a7a\u5bfc\u81f4");
                }
                if (!StringUtils.isEmpty((CharSequence)title)) {
                    TextView tv = new TextView((Context)this._mActivity);
                    tv.setLayoutParams((ViewGroup.LayoutParams)TITLE_BAR_RIGHT_TV_LAYOUT_PARAMS);
                    tv.setGravity(4);
                    tv.setText((CharSequence)title);
                    tv.setTextSize(2, 14.0f);
                    tv.setTextColor(this.mTitleBarBtnColor);
                    if (!StringUtils.isEmpty((CharSequence)listener)) {
                        tv.setOnClickListener(v -> this.safetyCallH5(listener, null));
                    }
                    this.mTitleBarRightContainer.addView((View)tv);
                    continue;
                }
                if (!StringUtils.isEmpty((CharSequence)iconUrl)) {
                    ImageView imageView = new ImageView((Context)this._mActivity);
                    imageView.setLayoutParams((ViewGroup.LayoutParams)TITLE_BAR_RIGHT_ICON_LAYOUT_PARAMS);
                    Glide.with((Fragment)this).asBitmap().load(iconUrl).into(imageView);
                    imageView.setOnClickListener(v -> this.safetyCallH5(listener, null));
                    this.mTitleBarRightContainer.addView((View)imageView);
                    continue;
                }
                LoggerProxy.e("\u914d\u7f6e\u6807\u9898\u680f\u53f3\u8fb9\u81ea\u5b9a\u4e49\u83dc\u5355\uff0c\u4f20\u9012\u7684\u53c2\u6570\u9519\u8bef\uff0c\u6807\u9898\u6216\u8005\u56fe\u6807\u4e3a\u7a7a\u5bfc\u81f4");
            }
        }));
    }

    public void setAddTitleBarRightMenus() {
        this.mTitleBarRightContainer.removeAllViews();
    }

    public void setTitleBarEventListener(ITitleBarEventListener titleBarEventListener) {
        this.mTitleBarEventListener = titleBarEventListener;
    }

    @Override
    public void onLoadStart(WebView view) {
        super.onLoadStart(view);
        this.showProgressBar();
    }

    @Override
    public void onLoadEnd(boolean isMainUiThreadCall) {
        super.onLoadEnd(isMainUiThreadCall);
        if (!this.isShowErrorLocalPage) {
            if (!isMainUiThreadCall) {
                this.post(this::_onLoadEndHandlerUI);
            } else {
                this._onLoadEndHandlerUI();
            }
        }
    }

    private void _onLoadEndHandlerUI() {
        if (this.mSmartRefreshLayout != null) {
            this.mSmartRefreshLayout.finishRefresh();
        }
        this.post(this::hideProgressBar);
        if (this.mWebViewDelegate.isWebViewAvailable()) {
            this.isErrContainerVisible(false);
        }
    }

    @Override
    public void onInterceptorNoSupportProtocol(String url) {
        super.onInterceptorNoSupportProtocol(url);
    }

    @Override
    public void onReceivedError(WebView webView, int errorCode, String description, String failingUrl) {
        super.onReceivedError(webView, errorCode, description, failingUrl);
        LoggerProxy.d("webview\u4ee3\u7406\u88ab\u8c03\u7528 onReceivedError %s %s %s", this.mURL, errorCode, failingUrl);
        String hintTxt = String.format("\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u5c1d\u8bd5\u8bbf\u95ee [%s]", failingUrl, errorCode);
        if (errorCode == -2 || errorCode == -3 || errorCode == -6 || errorCode == -7 || errorCode == -12) {
            hintTxt = String.format("\u4e0e\u670d\u52a1\u5668\u8fde\u63a5\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5 [%s] ", errorCode);
        } else if (errorCode == -4 || errorCode == -5) {
            hintTxt = String.format("\u4f60\u6ca1\u6709\u6743\u9650\u8bbf\u95ee [%s]", errorCode);
        } else if (errorCode == -8) {
            hintTxt = String.format("\u8bbf\u95ee\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5 [%s]", errorCode);
        } else if (errorCode == -9 || errorCode == -15) {
            hintTxt = String.format("\u8bbf\u95ee\u8d44\u6e90\u51fa\u73b0\u91cd\u590d\u591a\u6b21\u91cd\u5b9a\u5411\u6216\u592a\u591a\u8bf7\u6c42\u53d1\u9001\u9519\u8bef [%s]", errorCode);
        } else if (errorCode == -10) {
            hintTxt = String.format("\u8bbf\u95ee\u4e0d\u5b89\u5168\u7684\u534f\u8bae\u8d44\u6e90\u9519\u8bef [%s]", errorCode);
        } else if (errorCode == -11 || errorCode == -16) {
            hintTxt = String.format("\u8bbf\u95ee\u4e0d\u5b89\u5168\u7684SSL\u534f\u8bae\u8d44\u6e90\u9519\u8bef [%s]", errorCode);
        } else if (errorCode == 404) {
            hintTxt = String.format("\u5f85\u8bbf\u95ee\u7684\u8d44\u6e90\u4e0d\u5b58\u5728 [%s]", errorCode);
        } else if (errorCode == 500) {
            hintTxt = String.format("\u5f85\u8bbf\u95ee\u7684\u8d44\u6e90\u53d1\u9001\u670d\u52a1\u5668\u7aef\u9519\u8bef [%s]", errorCode);
        }
        this.onLoadPageErr(webView, hintTxt);
    }

    @Override
    public void onProgressChanged(WebView view, int progress) {
        this.setProgress(progress);
    }

    protected void onLoadPageErr(WebView view, String hintTxt) {
        ToastUtils.showLong((CharSequence)hintTxt);
        this.isShowErrorLocalPage = true;
        if (this.mWebViewDelegate.isWebViewAvailable()) {
            KeyboardUtils.hideSoftInput((Activity)((Activity)Objects.requireNonNull(this._mActivity)));
            this.hideProgressBar();
            this.mSmartRefreshLayout.finishRefresh();
            this.isErrContainerVisible(true);
            this.mErrTextView.setText((CharSequence)hintTxt);
        } else {
            LoggerProxy.w("\u7f51\u9875\u4ee3\u7406\u5bf9\u8c61\u5df2\u7ecf\u88ab\u9500\u6bc1\uff0c\u4f46\u662f\u8fd8\u8c03\u7528\u4e86handlerWebViewLoadingTimeout %s", this.mURL);
        }
    }

    protected void isErrContainerVisible(boolean errContainerVisible) {
        if (null != this.mSmartRefreshLayout) {
            this.mSmartRefreshLayout.finishRefresh();
        }
        this.hideProgressBar();
        if (this.mPlaceholderContainer != null && this.isOpenH5PlaceholderPage() == 0) {
            this.mPlaceholderContainer.setVisibility(8);
        }
        if (errContainerVisible) {
            this.isShowErrorLocalPage = true;
            if (null != this.mSmartRefreshLayout && this.mSmartRefreshLayout.getVisibility() == 0) {
                this.mSmartRefreshLayout.setVisibility(8);
            }
            if (null != this.mErrContainer && this.mErrContainer.getVisibility() == 8) {
                this.mErrContainer.setVisibility(0);
            }
        } else {
            this.isShowErrorLocalPage = false;
            if (null != this.mErrContainer && this.mErrContainer.getVisibility() == 0) {
                this.mErrContainer.setVisibility(8);
            }
            if (null != this.mSmartRefreshLayout && this.mSmartRefreshLayout.getVisibility() == 8) {
                this.mSmartRefreshLayout.setVisibility(0);
            }
        }
    }

    public boolean isShowErrorLocalPage() {
        return this.isShowErrorLocalPage;
    }

    public void setShowErrorLocalPage(boolean isShowErrorLocalPage) {
        this.isShowErrorLocalPage = isShowErrorLocalPage;
    }

    public MaterialProgressBar hideProgressBar() {
        if (this.progressBar != null) {
            this.progressBar.setProgress(100);
            this.progressBar.setVisibility(8);
        }
        return this.progressBar;
    }

    public MaterialProgressBar showProgressBar() {
        if (this.progressBar != null) {
            this.progressBar.setVisibility(0);
        }
        return this.progressBar;
    }

    public MaterialProgressBar setProgress(int progress) {
        this.progressBar.setProgress(progress);
        this.progressBar.setSecondaryProgress(10 + progress);
        return this.progressBar;
    }

    public void setTitle(@NonNull String title) {
        this.mTitle = title;
        if (this.centerTextView != null) {
            this.centerTextView.setText((CharSequence)this.mTitle);
        }
    }

    public ITitleBarEventListener getTitleBarEventListener() {
        return this.mTitleBarEventListener;
    }

    public SmartRefreshLayout getSmartRefreshLayout() {
        return this.mSmartRefreshLayout;
    }

    @Override
    public FragmentAnimator onCreateFragmentAnimator() {
        return new DefaultHorizontalAnimator();
    }

    public static interface ITitleBarEventListener {
        public boolean onBackBtnClick();

        public void onCloseBtnClick();
    }
}

